% Generated by roxygen2 (4.0.2): do not edit by hand
\name{parDepPlot}
\alias{parDepPlot}
\title{Binary Classifier Interpretation functions: Partial Dependence Plots}
\usage{
parDepPlot(x.name, object, data, rm.outliers = TRUE, fact = 1.5,
  n.pt = 50, robust = FALSE, ci = FALSE, u.quant = 0.75,
  l.quant = 0.25, xlab = x.name, ylab = NULL, main = if
  (any(class(object) \%in\% c("randomForest", "ada")))
  paste("Partial Dependence on", x.name) else
  paste("Cross-Validated Partial Dependence on", x.name), ...)
}
\arguments{
\item{x.name}{the name of the predictor as a character string for which a partial dependence plot has to be created.}

\item{object}{can be a model or a list of cross- validated models. Currently only binary classification models built using the packages \code{randomForest} and \code{ada} are supported.}

\item{data}{a data frame containing the predictors for the model or a list of data frames for cross-validation with length equal to the number of models.}

\item{rm.outliers}{boolean, remove the outliers in x.name. Outliers are values that are smaller than max(Q1-fact*IQR,min) or greater than min(Q3+fact*IQR,max).}

\item{fact}{factor to use in rm.outliers. The default is 1.5.}

\item{n.pt}{if x.name is a continuous predictor, the number of points that will be used to plot the curve.}

\item{robust}{if TRUE than the median is used to plot the central tendency. If FALSE the mean is used.}

\item{ci}{boolean. Should a confidence interval based on quantiles be plotted? This only works if robust=TRUE.}

\item{u.quant}{Upper quantile for ci. This only works if ci=TRUE and robust=TRUE.}

\item{l.quant}{Lower quantile for ci. This only works if ci=TRUE and robust=TRUE.}

\item{xlab}{label for the x-axis. Is determined automatically if NULL.}

\item{ylab}{label for the y-axis.}

\item{main}{main title for the plot.}

\item{...}{other graphical parameters for \code{plot}.}
}
\description{
\code{parDepPlot} creates partial dependence plots for binary (cross-validated) classification models. Currently only binary classification models estimated with the packages \code{randomForest} and \code{ada} are supported.
}
\details{
The response variable in the model is always assumed to take on the values \{0,1\}. Resulting partial dependence plots always refer to class 1. Whenever strange results are obtained the user has three options. First set rm.outliers=TRUE. Second, if that doesn't help, set robust=TRUE. Finally, if that doesn't help, the user can also try setting ci=TRUE. Areas with larger confidence intervals typically indicate problem areas. These options help the user tease out the root of strange results and converge to better parameter values.
}
\examples{
library(randomForest)
#Prepare data
data(iris)
iris <- iris[1:100,]
iris$Species <- as.factor(ifelse(factor(iris$Species)=="setosa",0,1))

#Cross-validated models
#Estimate 10 models and create 10 test sets
data <- list()
rf <- list()
for (i in 1:10) {
  ind <- sample(nrow(iris),50)
  rf[[i]] <- randomForest(Species~., iris[ind,])
  data[[i]] <- iris[-ind,]
}


parDepPlot(x.name="Petal.Width", object=rf, data=data)

#Single model
#Estimate a single model
ind <- sample(nrow(iris),50)
rf <- randomForest(Species~., iris[ind,])
parDepPlot(x.name="Petal.Width", object=rf, data=iris[-ind,])
}
\author{
Authors: Michel Ballings, and Dirk Van den Poel, Maintainer: \email{Michel.Ballings@GMail.com}
}
\references{
The code in this function uses part of the code from the \code{partialPlot} function in \code{randomForest}. It is expanded and generalized to support cross-validation and other packages.
}
\seealso{
\code{\link{variableImportance}}
}

