% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_table.R
\name{include_table}
\alias{include_table}
\title{Table with footnotes}
\usage{
include_table(
  data,
  caption = NULL,
  notes = NULL,
  label = "Note:",
  notation = "alphabet"
)
}
\arguments{
\item{data}{Data frame.}

\item{caption}{Table caption (default = NULL). See details.}

\item{notes}{Footnotes for the table (default = NULL). See details.}

\item{label}{Label for start the footnote (default = "Note:").}

\item{notation}{Notation for the symbols and footnotes (default =
"alphabet"). See details.}
}
\value{
Table with caption and footnotes
}
\description{
Include tables with notes and titles for word and html documents
}
\details{
For \code{caption} and \code{notes} you can include {caption} and {notes} in
the last rows of your data frame. Where the information will be extracted
automatically for include in the formatted table. You can add the footnote
symbol using \code{{hypen}} in your table. \code{notation} could be use:
"alphabet", "number", "none".
}
\examples{


library(googlesheets4)
library(inti)

if (gs4_has_token()) {

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "1ilw0NHT7mihaM-3U48KzkuMt927xe8ukX6rNuIw2fT0/edit#gid=1157916926")

# browseURL(url)
gs <- as_sheets_id(url)

table <- gs \%>\%
    range_read("footnotes")

table \%>\% inti::include_table(label = "_Nota:_"
                              , notation = "num"
)

}

}
