% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_comparison.R
\name{mean_comparison}
\alias{mean_comparison}
\title{Mean comparison test}
\usage{
mean_comparison(
  data,
  response,
  model_factors,
  comparison,
  test_comp = "SNK",
  sig_level = 0.05
)
}
\arguments{
\item{data}{Fieldbook data.}

\item{response}{Model used for the experimental design.}

\item{model_factors}{Factor in the model.}

\item{comparison}{Significance level for the analysis (default = 0.05).}

\item{test_comp}{Comparison test (default = "SNK"). Others: "TUKEY", "DUNCAN".}

\item{sig_level}{Significance level for the analysis (default = 0.05).}
}
\value{
list
}
\description{
Function to compare treatment from lm or aov using data frames
}
\examples{

\dontrun{

library(inti)
library(gsheet)

url <- paste0("https://docs.google.com/spreadsheets/d/"
              , "15r7ZwcZZHbEgltlF6gSFvCTFA-CFzVBWwg3mFlRyKPs/"
              , "edit#gid=172957346")
# browseURL(url)

fb <- gsheet2tbl(url)

mc <- mean_comparison(data = fb
                      , response = "hi"
                      , model_factors = "geno*treat"
                      , comparison = c("geno", "treat")
                      , test_comp = "TUKEY"
                      )
mc$comparison
mc$stat

}

}
