% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hibrid_pois.R
\name{Hibrid_pois}
\alias{Hibrid_pois}
\title{Hibrid_pois}
\usage{
Hibrid_pois(
  demand,
  leadtime,
  service_level,
  lambda,
  Review_period,
  min = FALSE,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{lambda}{rate of demand in N time periods.}

\item{Review_period}{the period where the ordering happens.}

\item{min}{min quantity for order up to level,if FALSE, then calculated automatically.}

\item{shortage_cost}{shortage cost per unit of sales lost}

\item{inventory_cost}{inventory cost per unit.}

\item{ordering_cost}{ordering cost for every time an order is made.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Hibrid Policy Poisson distribution service level,  .
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and 
requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated.
 the order up to level is calculated based on the review period,lead time and normal distribution.
 Inventory is replenished if inventory position is below min or it is time for review period.
}
\examples{

Hibrid_pois(demand=rpois(80,6),lambda=4,leadtime=5,service_level=0.65,
Review_period =9,min=30,
shortage_cost= FALSE,inventory_cost=FALSE,ordering_cost=FALSE)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
