% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenario_sim.R
\encoding{utf-8}
\name{scenario_sim}
\alias{scenario_sim}
\title{Simulate SONE values for scenario.}
\usage{
scenario_sim(sizes, n_sim, to_n, tn_n = 8 - to_n, ...)
}
\arguments{
\item{sizes}{An array of sample sizes to be simulated. Can be single value.}

\item{n_sim}{number of simulations. 1000 is a start, 10000 was used in paper, but takes a long time}

\item{to_n}{Number of indicators in a Trait relating to Outcome}

\item{tn_n}{Number of indicators in a Trait Not relating to outcome.}

\item{...}{further tweaking of the scale simulator, see  \code{\link{scale_sim}} for details.}
}
\value{
Returns a list of SONE values and related efficacy. See example for details
\enumerate{
  \item SONE results. Feed this to  \code{\link{scenario_plot}} or \code{\link{scenario_plot80}} (see examples)
  \item Summary efficacy. Such data comprises Table 1 in Vainik, Mottus et al., 2015 EJP
  \item Full efficacy data.
}
}
\description{
A wrapper that takes a scenario, and produces the Significance Of iNdicator Exclusion (SONE) values for each exclusion and calculates efficacy. Used by  \code{\link{optimal_p}}.
}
\examples{

#A scenario with 8 items relating to outcome, testing 2 different samples
sizes=c(250,500)
n_sim=100
to_n=8
scen1=scenario_sim(sizes,n_sim,to_n)  # takes a few seconds..
scenario_plot80(scen1[[1]],sizes,n_sim)

# A scenario with 2 out of 8 items relating to outcome, 2 different samples
to_n=2
scen2=scenario_sim(sizes,n_sim,to_n)  # takes a few seconds..
scenario_plot(scen2[[1]],sizes,n_sim,to_n)

}

