% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_effects_create.R
\name{direct_effects_create}
\alias{direct_effects_create}
\title{Create direct effects}
\usage{
direct_effects_create(labelled_io_table, type = "final_demand",
  digits = NULL)
}
\arguments{
\item{labelled_io_table}{A named (primary) input(s) vector or matrix created by \code{\link{primary_input_get}}}

\item{type}{Defaults to \code{final_demand}. Alternatives are \code{domestic_demand} or 
or \code{'intermediate_demand'}.}

\item{digits}{Rounding digits, defaults to \code{NULL}, in which case 
no rounding takes place.}
}
\description{
The function creates the direct effects on total supply (or other supply 
category). See Eurostat Manual p498.
}
\examples{
 

io_table <- iotable_get () 
#Total column should not be missing
io_table <- io_table [, 1:7] 
io_table$total <- rowSums(io_table[, 2:7])

labelled_io_table <- io_table
direct_effects_create ( io_table ) 
}
