% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_multipliers_create.R
\name{input_multipliers_create}
\alias{input_multipliers_create}
\title{Create input multipliers}
\usage{
input_multipliers_create(direct_effects, inverse, labelled = TRUE,
  digits = NULL)
}
\arguments{
\item{direct_effects}{A direct effects matrix created by 
\code{\link{direct_effects_create}}}

\item{inverse}{A Leontieff-inverse created by \code{\link{leontieff_inverse_create}}.}

\item{labelled}{Defaults to \code{TRUE}. If you use not labelled matrixes, i.e. 
both inputed matrixes are numerical only without the first key row, select 
\code{FALSE}.}

\item{digits}{Rounding digits, defaults to \code{NULL}, in which case 
no rounding takes place.}
}
\description{
The function creates the input multipliers.  See Eurostat Manual p500-501..
}
\examples{
 
de_use <- use_table_get()
L_de  <- leontieff_matrix_create( de_use )
I_de <- leontieff_inverse_create( L_de )

io_table <- iotable_get () 
#Total column should not be missing
io_table <- io_table [, 1:7] 
io_table$total <- rowSums(io_table[, 2:7])

labelled_io_table <- io_table
direct_effects_de <- direct_effects_create ( io_table ) 

multipliers <- input_multipliers_create(
      direct_effects = direct_effects_de [, -8],
      inverse = I_de, 
      labelled = TRUE)
}
