% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/employment_get.R
\name{employment_get}
\alias{employment_get}
\title{Get employment data}
\source{
Eurostat statistic \href{http://appsso.eurostat.ec.europa.eu/nui/show.do?dataset=lfsq_egan22d&lang=en}{Employment 
by sex, age and detailed economic activity (from 2008 onwards, NACE Rev. 2 two digit level) - 1 000}
}
\usage{
employment_get(geo = "CZ", year = "2010", sex = "Total",
  age = "Y_GE15", labelling = "iotables", data_directory = NULL,
  force_download = TRUE)
}
\arguments{
\item{geo}{The country code.}

\item{year}{The year.  The average employment will be created for the given
year, starting with \code{2008}, when the NACE Rev 2 was introduced in 
employment statistics.}

\item{sex}{Defaults to \code{"Total"}. Enter \code{"Females"} or \code{"F"} for
female employment, \code{"Males"} or \code{"M"} for male employment.}

\item{age}{Defaults to \code{"Y_GE15"}, which is the Eurostat code for employment in 
all age groups starting from 15-years-old. Any Eurostat code can be used as a 
parameter.}

\item{labelling}{Either \code{"iotables"} or the applicable short code, 
for product x product SIOTs \code{"prod_na"} and in the case of industry x 
industry SIOTs \code{"induse"}.}

\item{data_directory}{Defaults to \code{NULL}, if a valid directory, it will try to save the pre-processed 
data file here with labelling.}

\item{force_download}{Defaults to \code{TRUE}. If \code{FALSE} it will use the existing downloaded file
in the \code{data_directory} or the temporary directory, if it exists.}
}
\description{
Download the employment data for a country and arrange it to the 64x64 SIOTS.
Currently works only with product x product tables.
}
\examples{
\dontrun{
 io_tables <- get_employment ( 
               geo = "CZ", 
               year = "2010",
               sex = "Total", 
               age = "Y_GE15",
               data_directory = NULL,
               force_download = TRUE
               )
 }
}
