% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_flow_get.R
\name{input_flow_get}
\alias{input_flow_get}
\title{Create a use (input flow) matrix}
\usage{
input_flow_get(data_table, empty_remove = FALSE, households = TRUE)
}
\arguments{
\item{data_table}{A symmetric input-output table or use table 
retrieved by the \code{\link{iotable_get}} function.}

\item{empty_remove}{Defaults to \code{TRUE}. If you want to keep empty 
primary input rows, choose \code{FALSE}. Empty product/industry rows are always 
removed to avoid division by zero error in the analytical functions.}

\item{households}{Defaults to \code{FALSE}. If \code{TRUE}, the 
final household expenditure is added to the input flow table.}
}
\value{
A data flow matrix in a labelled data frame.
}
\description{
Select the use table from a symmetric input-output table.
}
\examples{
data_table <- iotable_get()
input_flow <- input_flow_get( data_table = data_table, 
                         empty_remove = FALSE,
                         households = TRUE)

}
\seealso{
Other analytical object functions: 
\code{\link{leontieff_matrix_create}()}
}
\concept{analytical object functions}
