% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_iota2_alluvial}
\alias{plot_iota2_alluvial}
\title{Plot of the Coding Stream}
\usage{
plot_iota2_alluvial(
  object,
  label_titel = "Coding Stream from True to Assigned Categories",
  label_prefix_true = "true",
  label_prefix_assigned = "labeled as",
  label_legend_title = "True Categories",
  label_true_category = "True Category",
  label_assigned_category = "Assigned Category",
  label_y_axis = "Relative Frequencies",
  label_categories_size = 3,
  key_size = 0.5,
  text_size = 10
)
}
\arguments{
\item{object}{Estimates of Iota 2 created with \code{compute_iota2()},
\code{check_new_rater()} or with \code{check_dgf()}. Please note that the object
created by \code{check_dgf()} cannot be passed directly. Only the elements of
the corresponding list are compatible.}

\item{label_titel}{\code{Character} containing the title of the plot.}

\item{label_prefix_true}{\code{Character} representing the prefix for tagging
the true categories. Character is applied to every category.}

\item{label_prefix_assigned}{\code{Character} representing the prefix for tagging
the assigned categories. Character is applied to every category.}

\item{label_legend_title}{\code{Character} containing the title of the legend.}

\item{label_true_category}{\code{Character} describing the stratum of true
categories.}

\item{label_assigned_category}{\code{Character} describing the stratum of
assigned categories.}

\item{label_y_axis}{\code{Character}. Label of the y-axis.}

\item{label_categories_size}{\code{double} determining the size of the
label for each true and assigned category within the plot.}

\item{key_size}{\code{double} determining the size of the legend.}

\item{text_size}{\code{double} determining the size of the text within the legend.}
}
\value{
Returns an object of class \code{gg} and \code{ggplot} which can be
shown with \code{plot()}.
}
\description{
Function for creating an alluvial plot that can be plotted via \link{ggplot2}.
}
\note{
An example for interpreting the plot can be found in the vignette
\href{../iotarelr.html}{Get started} or via
\code{vignette("iotarelr", package = "iotarelr")}.
}
