% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consumer.R
\docType{data}
\name{Consumer}
\alias{Consumer}
\title{A Class for reading and executing tasks from a source}
\arguments{
\item{source}{a source, e.g. TextFileSource.}

\item{millis}{milliseconds.}

\item{env}{An enviroment specifying where to execute signals.}

\item{signal}{A string.}

\item{index}{A position.}
}
\description{
\strong{Methods}
  \describe{
    \item{\code{initialize(source, env=parent.frame(2))}}{
      Creates a Consumer object linked to the \code{source}.
    }
    \item{\code{setSource(source)}}{
      Sets the \code{Source} for this consumer.
    }
    \item{\code{getSource(source)}}{
      Gets the \code{Source} of this consumer.
    }
    \item{\code{consume(throwErrors=TRUE, env=parent.frame())}}{
      Executes all (unprocessed) signals fired to source from a Producer.
      if \code{throwErrors} is TRUE, the first error encountered is thrown
      after executing all signals. Signals are executed in the \code{env} environment.
      If \code{env} is NULL, the enviroment set at initialization is used.
    }
    \item{\code{start(millis=250, throwErrors=TRUE, env=parent.frame())}}{
      Starts executing \code{consume} every \code{millis} milliseconds. \code{throwErrors}
      and \code{env} are passed down to \code{consume}
    }
    \item{\code{stop()}}{
      Stops the periodic execution of \code{consume}.
    }
    \item{\code{clearHandlers()}}{
      Removes all handlers
    }
    \item{\code{removeHandler(signal, index)}}{
      Removes handler from 'signal' with position index
    }
    \item{\code{addHandler(func, signal)}}{
      Adds a handler for 'signal'. func should take three parameters: 1. the signal, 2. the message object, and 3. the evaluation environment.
    }
    \item{\code{initHandlers()}}{
      Adds the two default executeors.
    }
    \item{\code{finalize()}}{
      runs stop on object distruction
    }
  }
}
\keyword{datasets}
