% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipeadata_pkg.R
\name{available_series}
\alias{available_series}
\title{List with available series}
\usage{
available_series(language = c("en", "br"))
}
\arguments{
\item{language}{String specifying the selected language. Language options are
English (\code{"en"}, default) and Brazilian portuguese (\code{"br"}).}
}
\value{
A data frame containing Ipeadata code, name, theme, source,
frequency, last update and activity status of available series.
}
\description{
Returns a list with available series from Ipeadata API database.
}
\note{
The original language of the available series' names were preserved.
}
\examples{
\donttest{
# Available series (in English)
all_series <- available_series()

# Available series (in Brazilian portuguese)
all_seriesBR <- available_series(language = "br")

}

}
