% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{print.proto_ipm}
\alias{print.proto_ipm}
\alias{print.simple_di_det_ipm}
\alias{print.simple_di_stoch_kern_ipm}
\alias{print.simple_di_stoch_param_ipm}
\alias{print.general_di_det_ipm}
\alias{print.general_di_stoch_kern_ipm}
\alias{print.general_di_stoch_param_ipm}
\title{Print proto_ipms or *_ipm objects}
\usage{
\method{print}{proto_ipm}(x, ...)

\method{print}{simple_di_det_ipm}(
  x,
  comp_lambda = TRUE,
  type_lambda = "all",
  sig_digits = 3,
  check_conv = TRUE,
  ...
)

\method{print}{simple_di_stoch_kern_ipm}(x, comp_lambda = TRUE, type_lambda = "stochastic", sig_digits = 3, ...)

\method{print}{simple_di_stoch_param_ipm}(x, comp_lambda = TRUE, type_lambda = "stochastic", sig_digits = 3, ...)

\method{print}{general_di_det_ipm}(
  x,
  comp_lambda = TRUE,
  type_lambda = "last",
  sig_digits = 3,
  check_conv = TRUE,
  ...
)

\method{print}{general_di_stoch_kern_ipm}(x, comp_lambda = TRUE, type_lambda = "stochastic", sig_digits = 3, ...)

\method{print}{general_di_stoch_param_ipm}(x, comp_lambda = TRUE, type_lambda = "stochastic", sig_digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{proto_ipm} or produced by \code{make_ipm()}.}

\item{...}{Ignored}

\item{comp_lambda}{A logical indicating whether or not to calculate lambdas
for the iteration kernels and display them.}

\item{type_lambda}{Either \code{'all'} or \code{'stochastic'}. See
\code{\link{lambda}} for more details.}

\item{sig_digits}{The number of significant digits to round to if \code{
comp_lambda = TRUE}.}

\item{check_conv}{A logical: for deterministic models, check if population state
has converged to asymptotic dynamics? If \code{TRUE} and the model has not
converged, a message will be printed.}
}
\value{
\code{x} invisibly.
}
\description{
Print proto_ipms or *_ipm objects

Generics for IPM classes
}
\details{
For printing \code{proto_ipm} objects, indices are wrapped in
\code{<index>} to assist with debugging. These are not carried into the model,
just a visual aid.
}
