% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fbmOptim.R
\name{fbmOptim}
\alias{fbmOptim}
\title{Find the Hurst coefficient of a FBM I-prior model}
\usage{
fbmOptim(object, method = c("ipriorOptim", "iprior"), silent = FALSE)
}
\arguments{
\item{object}{An object of class \code{ipriorKernel}.}

\item{method}{One of \code{c("ipriorOptim", "iprior")} for model fitting of
the final I-prior model.}

\item{silent}{(logical) Run the optimisation silently or not.}
}
\value{
An \code{ipriorMod} object.
}
\description{
From an \code{ipriorKernel} object, a golden section search of (0,1) is
performed using \code{optimize()}.
}
\details{
Currently, \code{fbmOptim()} will only search for a single optimum Hurst
coefficient. If the model specified has multiple Hurst coefficients, this
will be overridden with the single optimal Hurst value.
}
\examples{
mod <- kernL(y ~ ., datfbm, model = list(kernel = "FBM"))
(mod.iprior <- fbmOptim(mod))
}

