% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_read.r
\name{read_ipums_sf}
\alias{read_ipums_sf}
\alias{read_ipums_sp}
\title{Read boundary files from an IPUMS extract}
\usage{
read_ipums_sf(shape_file, shape_layer = NULL, encoding = NULL,
  bind_multiple = TRUE, verbose = TRUE)

read_ipums_sp(shape_file, shape_layer = NULL, bind_multiple = TRUE,
  verbose = TRUE, encoding = NULL)
}
\arguments{
\item{shape_file}{Filepath to one or more .shp files, a .zip file from an IPUMS extract
or a path to an unzipped folder.}

\item{shape_layer}{For .zip extracts with multiple datasets, the name of the
 shape files to load. Accepts a character vector specifying the file name, or
\code{\link{dplyr_select_style}} conventions. Can load multiple shape files,
  which will be combined.}

\item{encoding}{The text encoding to use when reading the shape file. Typically
the defaults should read the data correctly, but for some extracts you may
need to set them manually, but if funny characters appear in your data, you
may need to. For microdata projects, the default NULL will look for a .cpg
file to determine the encoding and if none is available, it will default to
latin1. The NHGIS and the IPUMS Terra functions specify the encoding for
those projects (latin1 and UTF-8 respectively).}

\item{bind_multiple}{If \code{TRUE}, will combine multiple shape files found into
a single object.}

\item{verbose}{I \code{TRUE}, will report progress information}
}
\value{
\code{read_ipums_sf} returns a sf object and \code{read_ipums_sp} returns
  a SpatialPolygonsDataFrame.
}
\description{
Reads the boundary files from an IPUMS extract into R as simple features (sf) objects or
SpatialPolygonsDataFrame (sp) objects.
}
\examples{
shape_file <- ipums_example("nhgis0008_shape_small.zip")
# If sf package is availble, can load as sf object
if (require(sf)) {
  sf_data <- read_ipums_sf(shape_file)
}

# If sp package is available, can load as SpatialPolygonsDataFrame
if (require(sp) && require(rgdal)) {
  sp_data <- read_ipums_sp(shape_file)
}

}
\seealso{
Other ipums_read: \code{\link{read_ipums_micro}},
  \code{\link{read_nhgis}}, \code{\link{read_terra_area}},
  \code{\link{read_terra_micro}},
  \code{\link{read_terra_raster}}
}
