% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhgis_read.r
\name{read_nhgis}
\alias{read_nhgis}
\alias{read_nhgis_sf}
\alias{read_nhgis_sp}
\title{Read data from an NHGIS extract}
\usage{
read_nhgis(
  data_file,
  data_layer = NULL,
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)

read_nhgis_sf(
  data_file,
  shape_file,
  data_layer = NULL,
  shape_layer = data_layer,
  shape_encoding = "latin1",
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)

read_nhgis_sp(
  data_file,
  shape_file,
  data_layer = NULL,
  shape_layer = data_layer,
  shape_encoding = "latin1",
  verbose = TRUE,
  var_attrs = c("val_labels", "var_label", "var_desc")
)
}
\arguments{
\item{data_file}{Filepath to the data (either the .zip file directly
downloaded from the website, the path to the unzipped folder, or
the path to the unzipped .csv file directly).}

\item{data_layer}{For .zip extracts with multiple datasets, the name of the
 data to load. Accepts a character vector specifying the file name, or
\code{\link{dplyr_select_style}} conventions. Data layer must uniquely identify
a dataset.}

\item{verbose}{Logical, indicating whether to print progress information to
console.}

\item{var_attrs}{Variable attributes to add from the codebook, defaults to
adding all (val_labels, var_label and var_desc). See
\code{\link{set_ipums_var_attributes}} for more details.}

\item{shape_file}{Filepath to the shape files (either the .zip
file directly downloaded from the website, or the path to the unzipped
folder, or the unzipped .shp file directly).}

\item{shape_layer}{(Defaults to using the same value as data_layer) Specification
of which shape files to load using the same semantics as \code{data_layer}. Can
load multiple shape files, which will be combined.}

\item{shape_encoding}{The text encoding to use when reading the shape file. Typically
the defaults should read the data correctly, but for some extracts you may need
to set them manually, but if funny characters appear in your data, you may need
to. Defaults to "latin1" for NHGIS.}
}
\value{
\code{read_nhgis} returns a \code{tbl_df} with only the tabular data,
\code{read_nhgis_sf} returns a \code{sf} object with data and the shapes, and
\code{read_nhgis_sp} returns a \code{SpatialPolygonsDataFrame} with data and
shapes.
}
\description{
Reads a dataset downloaded from the NHGIS extract system. Relies on csv files
(with or without the extra header row).
}
\examples{
csv_file <- ipums_example("nhgis0008_csv.zip")
shape_file <- ipums_example("nhgis0008_shape_small.zip")

data_only <- read_nhgis(csv_file)

# If sf package is availble, can load as sf object
if (require(sf)) {
  sf_data <- read_nhgis_sf(csv_file, shape_file)
}

# If sp package is available, can load as SpatialPolygonsDataFrame
if (require(rgdal) && require(sp)) {
  sp_data <- read_nhgis_sp(csv_file, shape_file)
}

}
\seealso{
Other ipums_read: 
\code{\link{read_ipums_micro_chunked}()},
\code{\link{read_ipums_micro_yield}()},
\code{\link{read_ipums_micro}()},
\code{\link{read_ipums_sf}()},
\code{\link{read_terra_area}()},
\code{\link{read_terra_micro}()},
\code{\link{read_terra_raster}()}
}
\concept{ipums_read}
