% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withValidationData.R
\name{EstValidation}
\alias{EstValidation}
\title{Estimation of ATE with Validation Data}
\usage{
EstValidation(maindata, validationdata, indA, indYerror, indX, indY,
  confidence = 0.95)
}
\arguments{
\item{maindata}{The non-validation main data in the form of R data frame}

\item{validationdata}{The validation data in the form of R data frame}

\item{indA}{A column name indicating the treatment variable}

\item{indYerror}{A column name indicating the misclassified outcome variable}

\item{indX}{A vector of column names indicating the covariates included in the treatment model}

\item{indY}{A column name indicating the true outcome variable}

\item{confidence}{The confidence level between 0 and 1; the default is 0.95 corresponding to a 95 per cent confidence interval}
}
\value{
A list of the estimate of average treatment effect, sandwich standard error, confidence interval, and the estimated sensitivity and specificity
}
\description{
Estimation of average treatment effect using the optimal linear combination method when misclassification probabilities are unknown but validation data are available
}
\examples{
#create main data and validation data with sensitivity=0.95 and specificity=0.85
set.seed(100)
X1=rnorm(1200)   
A=rbinom(1200,1,1/(1+exp(-0.2-X1)))
Y=rbinom(1200,1,1/(1+exp(-0.2-A-X1)))
y1=which(Y==1)
y0=which(Y==0) 
Yast=Y
Yast[y1]=rbinom(length(y1),1,0.95)
Yast[y0]=rbinom(length(y0),1,0.15)
mainda=data.frame(A=A,X1=X1,Yast=Yast)
X1=rnorm(800)   
A=rbinom(800,1,1/(1+exp(-0.2-X1)))
Y=rbinom(800,1,1/(1+exp(-0.2-A-X1)))
y1=which(Y==1)
y0=which(Y==0) 
Yast=Y
Yast[y1]=rbinom(length(y1),1,0.95)
Yast[y0]=rbinom(length(y0),1,0.15)
validationda=data.frame(A=A,X1=X1,Y=Y,Yast=Yast)
head(mainda)
head(validationda)
#apply the optimal linear combination correction method
EstValidation(mainda,validationda,"A","Yast","X1","Y",0.95)

}
