% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smcexec.R
\name{smcexec}
\alias{smcexec}
\title{modify chemical structures with SMC}
\usage{
smcexec(smchem, niter, nsteps = 5, preorder = 0, nview = 0)
}
\arguments{
\item{smchem}{SmcChem object}

\item{niter}{number of iterations}

\item{nsteps}{total number of letters extending and contracting in a iteration}

\item{preorder}{probability for reordering SMILES}

\item{nview}{number of structures shown after each iteration (if zero, structures are not shown)}
}
\description{
modify chemical structures with SMC
}
\examples{
data(engram_5k) 
data(qsprpred_EG_5k)
smchem <- SmcChem$new(smis = rep("c1ccccc1O", 25), v_qsprpred=qsprpred_EG_5k,
                     v_engram=engram_5k,temp=3)
smcexec(smchem, niter=5, preorder=0, nview=4)
#if OpenBabel (>= 2.3.1) is installed, you can use reordering for better mixing as 
#smcexec(smchem, niter=100, preorder=0.2, nview=4)
#see http://openbabel.org
}

