% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIModels.R
\name{use_Model}
\alias{use_Model}
\title{get the prediction from a given model}
\usage{
use_Model(newx = NULL, model_name = "elasticnet", model = NULL)
}
\arguments{
\item{newx}{is a matrix of features (e.g. fingerprints and/or physical descriptors), issued from a test/validation set, for
which the properties (e.g. targeted chemical properties) are predicted.}

\item{model_name}{is the model's name to be built ("elasticnet" by default).}

\item{model}{is the trained regression model, issued from \code{\link{get_Model}}, to be used as a predictor.}
}
\value{
the predicted properties.
}
\description{
Get the prediction from a desired regression model. For a Bayesian linear prediction, see \code{\link{use_linearBayes}}.
}
\examples{
\dontrun{elasticNet_pred <- use_Model(newx, model_name = "elasticnet", model = elasticnet_model)}

}
