% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel_coord.R
\name{parallel_coord}
\alias{parallel_coord}
\title{Parallel Coordinates Plot}
\usage{
parallel_coord(
  irace_results,
  id_configurations = NULL,
  param_names = NULL,
  iterations = NULL,
  only_elite = TRUE,
  by_n_param = NULL,
  color_by_instances = TRUE,
  filename = NULL
)
}
\arguments{
\item{irace_results}{The data generated when loading the \code{.Rdata} file created by \code{irace} (or the filename of that file).}

\item{id_configurations}{Configuration ids to be included in the
plot. Example: \code{c(20,50,100,300,500,600,700)}}

\item{param_names}{(\code{character()}) Parameters to be included in the plot. Example:
\code{c("algorithm","alpha","rho","q0","rasrank")}.}

\item{iterations}{Numeric vector, iteration number that should be included in the plot
(example: \code{iterations = c(1,4,5)})}

\item{only_elite}{logical (default \code{TRUE}), only print elite configurations (argument ignored when
\code{id_configurations} is provided)}

\item{by_n_param}{Numeric (optional), maximum number of parameters to be displayed.}

\item{color_by_instances}{Logical (default TRUE), choose how to color the lines. TRUE shows the number
of instances evaluated by the configuration in the colores. FALSE to show
the iteration number where the configuration was sampled.}

\item{filename}{(\code{character(1)}) File name to save the plot, for example \code{"~/path/example/filename.png"}.}
}
\value{
parallel coordinates plot
}
\description{
Parallel coordinates plot of a set of selected configurations. Each line in
the plot represents a configuration. By default, the final elite
configurations are shown. To visualize configurations of other iterations
these must be provided setting the argument \code{iterations}, configurations of
different iterations are shown in different colors. Setting the \code{only_elites}
argument to \code{FALSE} displays all configurations in the selected
iterations, specific configurations can be selected providing their ids in
the \code{id_configuration} argument.
}
\details{
The parameters to be included in the plot can be selected with the \code{param_names}
argument. Additionally, the maximum number of parameters to be displayed in one
plot. A list of plots is returned by this function if several plots are required
to display the selected data.

To export the plot to a file, it is possible to do it so manually using the
functionality provided by \link{plotly} in the plot. If a filename is provided,
an orca server will be used to export the plots and thus, it requires the library
to be installed (\url{https://github.com/plotly/orca}).
}
\examples{
iraceResults <- read_logfile(system.file(package="irace", "exdata",
                                         "irace-acotsp.Rdata", mustWork = TRUE))
parallel_coord(iraceResults)
\donttest{ 
parallel_coord(iraceResults, by_n_param = 5)
parallel_coord(iraceResults, only_elite = FALSE)
parallel_coord(iraceResults, id_configurations = c(20, 30, 40, 50, 100))
parallel_coord(iraceResults, param_names = c("algorithm", "alpha", "rho", "q0", "rasrank"))
parallel_coord(iraceResults, iterations = c(1, 4, 6))
}
}
