% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extdata.R
\name{sampled-ndvi-MODIS-MOD13Q1.csv}
\alias{sampled-ndvi-MODIS-MOD13Q1.csv}
\title{Raw MODIS MOD13Q1 NDVI data}
\format{
A data.table with 805 rows and 5 variables:
\itemize{
\item id - individual identifier
\item NDVI - sampled value
\item SummaryQA - Summary quality assessment value, see details below
\item DayOfYear - julian day/day of year of sample
\item yr - year of sample
}

SummaryQA details:

\itemize{
\item 0 - Good data, use with confidence
\item 1 - Marginal data, useful but look at detailed QA for more information
\item 2 - Pixel covered with snow/ice
\item 3 - Pixel is cloudy
}
}
\description{
A CSV containing NDVI samples for seven points over ten years (2005-2010).
Data extracted using Earth Engine with the example script provided by the
\code{use_example_ee_script()} function with sensor set to 'MODIS'.
}
\details{
Note: these are the same locations as in the example 'Landsat' data.
}
\examples{
# Load data.table
library(data.table)

# Read example data
ndvi <- fread(system.file('extdata', 'sampled-ndvi-MODIS-MOD13Q1.csv', package = 'irg'))
}
