# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Evaluate the log-density of a stationary Gaussian AR(1) process.
#'
#' Evaluate the log-density of a stationary Gaussian AR(1) process, observed at
#' times \code{times} taking values \code{x}.
#' @param x A vector of observed values.
#' @param mu A vector of expected values.
#' @param times A vector of the time points of observation.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A scalar, the log density.
#' @keywords internal
ar1_lpdf_cpp <- function(x, mu, times, rho, sigma) {
    .Call(`_irregulAR1_ar1_lpdf_cpp`, x, mu, times, rho, sigma)
}

#' Covariance matrix for a stationary Gaussian AR(1) process, observed at
#' consecutive timepoints.
#'
#' Creates the covariance matrix of an AR(1) process with parameters \code{rho}
#' and \code{sigma}, observed at \code{n} consecutive time points. The process
#' is assumed to be in stationarity and to have Gaussian errors.
#' @param n An integer greater than or equal to 1.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A matrix with \code{n} rows and \code{n} columns.
#' @export
#' @examples
#' n <- 5
#' rho <- 0.5
#' sigma <- 1
#' ar1_cov_consecutive(n, rho, sigma)
ar1_cov_consecutive <- function(n, rho, sigma) {
    .Call(`_irregulAR1_ar1_cov_consecutive`, n, rho, sigma)
}

#' Covariance matrix for a stationary Gaussian AR(1) process, observed at
#' irregularly spaced time points.
#'
#' Creates the covariance matrix of an AR(1) process with parameters \code{rho}
#' and \code{sigma}, observed at the time points in the vector \code{times}.
#' The process is assumed to be in stationarity and to have Gaussian errors.
#' @param times An vector of positive integers, preferably ordered.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A square matrix with \code{length(times)} rows.
#' @export
#' @examples
#' times <- c(1, 4:5, 7)
#' rho <- 0.5
#' sigma <- 1
#' ar1_cov_irregular(times, rho, sigma)
ar1_cov_irregular <- function(times, rho, sigma) {
    .Call(`_irregulAR1_ar1_cov_irregular`, times, rho, sigma)
}

#' Cross-covariance matrix of a stationary Gaussian AR(1) process.
#'
#' Creates the cross-covariance matrix of an AR(1) process with parameters
#' \code{rho} and \code{sigma}, observed at (positive) integer times
#' \code{times1} and \code{times2}, which may be irregularly spaced. The
#' process is assumed to be in stationarity and to have Gaussian errors.
#' @param times1 An vector of positive integers, preferably ordered.
#' @param times2 An vector of positive integers, preferably ordered.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A matrix with \code{length(times2)} rows and \code{length(times1)}
#'   columns.
#' @export
#' @examples
#' times1 <- c(1, 3, 6)
#' times2 <- c(2, 4, 8:9)
#' rho <- 0.5
#' sigma <- 1
#' ar1_cross_cov(times1, times2, rho, sigma)
ar1_cross_cov <- function(times1, times2, rho, sigma) {
    .Call(`_irregulAR1_ar1_cross_cov`, times1, times2, rho, sigma)
}

#' Upper triangular Cholesky decomposition for a stationary Gaussian AR(1)
#' process covariance matrix, observed at irregularly spaced time points.
#'
#' Creates the upper Cholesky triangle of the covariance matrix of an AR(1)
#' process with parameters \code{rho} and \code{sigma}, observed at the time
#' points in the vector \code{times}. The process is assumed to be in
#' stationarity and to have Gaussian errors.
#' @param times An vector of positive integers, preferably ordered.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A square matrix with \code{length(times)} rows.
#' @export
#' @examples
#' times <- c(1, 4:5, 7)
#' rho <- 0.5
#' sigma <- 1
#' ar1_cov_chol_irregular(times, rho, sigma)
ar1_cov_chol_irregular <- function(times, rho, sigma) {
    .Call(`_irregulAR1_ar1_cov_chol_irregular`, times, rho, sigma)
}

#' Sparse precision matrix for a stationary Gaussian AR(1) process, observed at
#' consecutive timepoints.
#'
#' Creates the precision (inverse covariance) matrix of an AR(1) process with
#' parameters \code{rho} and \code{sigma}, observed at \code{n} consecutive
#' time points. The process is assumed to be in stationarity and to have
#' Gaussian errors. The matrix is a tridiagonal band matrix and thus sparse.
#' @param n An integer greater than or equal to 1.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A matrix with \code{n} rows and \code{n} columns.
#' @export
#' @examples
#' library(Matrix)
#' n <- 5
#' rho <- 0.5
#' sigma <- 1
#' ar1_prec_consecutive(n, rho, sigma)
ar1_prec_consecutive <- function(n, rho, sigma) {
    .Call(`_irregulAR1_ar1_prec_consecutive`, n, rho, sigma)
}

#' Precision matrix for a stationary Gaussian AR(1) process, observed at
#' irregularly spaced time points.
#'
#' Creates the precision (inverse covariance) matrix of an AR(1) process with
#' parameters \code{rho} and \code{sigma}, observed at the time points in the
#' vector \code{times}. The process is assumed to be in stationarity and to
#' have Gaussian errors.
#' @param times An vector of positive integers, preferably ordered.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A square matrix with \code{length(times)} rows.
#' @export
#' @examples
#' library(Matrix)
#' times <- c(1, 4:5, 7)
#' rho <- 0.5
#' sigma <- 1
#' ar1_prec_irregular(times, rho, sigma)
ar1_prec_irregular <- function(times, rho, sigma) {
    .Call(`_irregulAR1_ar1_prec_irregular`, times, rho, sigma)
}

#' Upper Cholesky decomposition of a tridiagonal matrix.
#'
#' Creates the lower Cholesky decomposition of a tridiagonal matrix. The
#' decomposition will be a sparse lower triangular matrix with non-zero
#' elements only on the main diagonal and the diagonal below it.
#' @param Q A square tridiagonal matrix.
#' @return A sparse square matrix with the same size as the input matrix.
#' @export
#' @examples
#' library(Matrix)
#' times <- c(1, 4:5, 7)
#' rho <- 0.5
#' sigma <- 1
#' Q <- ar1_prec_irregular(times, rho, sigma)
#' chol_tridiag_upper(Q)
chol_tridiag_upper <- function(Q) {
    .Call(`_irregulAR1_chol_tridiag_upper`, Q)
}

#' Upper Cholesky triangle of the precision matrix of a stationary Gaussian
#' AR(1) process, observed at irregularly spaced time points.
#'
#' Creates the upper triangular Cholesky decomposition of the precision matrix
#' of an AR(1) process with parameters \code{rho} and \code{sigma}, observed at
#' the time points in the vector \code{times}. The process is assumed to be in
#' stationarity and to have Gaussian errors.
#' @param times An vector of positive integers, preferably ordered.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A sparse square matrix with \code{length(times)} rows.
#' @export
#' @examples
#' library(Matrix)
#' times <- c(1, 4:5, 7)
#' rho <- 0.5
#' sigma <- 1
#' ar1_prec_chol_irregular(times, rho, sigma)
ar1_prec_chol_irregular <- function(times, rho, sigma) {
    .Call(`_irregulAR1_ar1_prec_chol_irregular`, times, rho, sigma)
}

#' Backsolve with band 1 upper Cholesky.
#'
#' Backsolve with band 1 upper Cholesky.
#' @param U An upper triangular square matrix with non-zero entries only on the
#'   main diagonal and the first superdiagonal.
#' @param z A vector with as many elements as the number of rows of U.
#' @return A vector.
#' @keywords internal
band1_backsolve_vec <- function(U, z) {
    .Call(`_irregulAR1_band1_backsolve_vec`, U, z)
}

#' Backward substitution with band 1 lower Cholesky triangle and tridiagonal
#' RHS.
#'
#' Backward substitution with band 1 lower Cholesky triangle and tridiagonal
#' matrix on the right hand side.
#' @param L A lower triangular square matrix with non-zero entries only on the
#'   main diagonal and the first subdiagonal.
#' @param Q A tridiagonal matrix with the same dimensions as L.
#' @return A matrix.
#' @keywords internal
band1_backsolve_mat <- function(L, Q) {
    .Call(`_irregulAR1_band1_backsolve_mat`, L, Q)
}

#' Derivative of the precision matrix for a stationary Gaussian AR(1) process.
#'
#' Creates the derivate of the precision matrix of an AR(1) process with
#' respect to the parameter \code{rho}. The process has been observed at the
#' time points in the vector \code{times} and is assumed to be in stationarity,
#' and to have Gaussian errors.
#' @param times An vector of positive integers, preferably ordered.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A sparse square matrix with \code{length(times)} rows.
#' @export
#' @examples
#' library(Matrix)
#' times <- c(1, 4:5, 7)
#' rho <- 0.5
#' sigma <- 1
#' dprec_drho(times, rho, sigma)
dprec_drho <- function(times, rho, sigma) {
    .Call(`_irregulAR1_dprec_drho`, times, rho, sigma)
}

#' Multiply an upper triangular matrix with a band 1 upper triangular matrix.
#'
#' Multiply an upper triangular matrix with a band 1 upper triangular matrix.
#' @param A A sparse upper triangular matrix.
#' @param U A sparse band 1 upper triangular matrix of the same dimensions as
#'   \code{A}.
#' @return A sparse band 1 upper triangular matrix.
mult_U_band1U <- function(A, U) {
    .Call(`_irregulAR1_mult_U_band1U`, A, U)
}

#' Derivative of the upper Cholesky triangle of the precision matrix of a
#' stationary Gaussian AR(1) process.
#'
#' Creates the derivate of the upper Cholesky triangle of the precision matrix
#' of an AR(1) process with respect to the parameter \code{rho}.
#' @param U The upper Cholesky triangle of the precision matrix \code{Q} of the
#'   AR(1) process.
#' @param dQ The derivative of the precision matrix \code{Q} with respect to
#'   the correlation parameter \code{rho}.
#' @return A band 1 upper triangular matrix of the same dimensions as \code{U}.
#' @export
#' @examples
#' library(Matrix)
#' t <- c(1, 3:4, 6, 8)
#' r <- 0.5
#' s <- 1
#' U <- ar1_prec_chol_irregular(t, r, s)
#' dQ <- dprec_drho(t, r, s)
#' (dU <- dprecchol_drho(U, dQ))
dprecchol_drho <- function(U, dQ) {
    .Call(`_irregulAR1_dprecchol_drho`, U, dQ)
}

#' Simulate from a stationary Gaussian AR(1) process.
#'
#' Simulate from a stationary Gaussian AR(1) process at \code{n} consecutive
#' time points.
#' @param n The number of timepoints to simulate for.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A vector of length \code{n} with the process values.
#' @keywords internal
ar1_sim_cpp <- function(n, rho, sigma) {
    .Call(`_irregulAR1_ar1_sim_cpp`, n, rho, sigma)
}

#' Simulate from a stationary Gaussian AR(1) process at irregular times.
#'
#' Simulate from a stationary Gaussian AR(1) process at irregular times.
#' @param times The time points to simulate for.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A vector of length \code{n} with the process values.
#' @keywords internal
ar1_sim_irregular_cpp <- function(times, rho, sigma) {
    .Call(`_irregulAR1_ar1_sim_irregular_cpp`, times, rho, sigma)
}

#' Simulate from a stationary Gaussian AR(1) process.
#'
#' Simulate from a stationary Gaussian AR(1) process at \code{n} consecutive
#' time points.
#' @param pred_times A vector of time points to simulate at.
#' @param obs_times A vector of time points at which observations have been
#'   made.
#' @param x_obs The observed values of the process.
#' @param rho A real number strictly less than 1 in absolute value.
#' @param sigma A positive real number.
#' @return A vector of length \code{length(pred_times)} with the process
#'   values.
#' @keywords internal
ar1_sim_conditional_cpp <- function(pred_times, mu_pred, x_obs, obs_times, mu_obs, rho, sigma) {
    .Call(`_irregulAR1_ar1_sim_conditional_cpp`, pred_times, mu_pred, x_obs, obs_times, mu_obs, rho, sigma)
}

