% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isnilmm.R
\name{isnilmm}
\alias{isnilmm}
\title{Function for ISNI computation when the outcome follows LMM.}
\usage{
isnilmm(formula, data, random, id, weights, subset, predprobobs, misni = FALSE)
}
\arguments{
\item{formula}{an object of class "Formula": a symbolic description of the models to be fitted for the outcome and missingness status variable.
The details of model specification are given under "Details".}

\item{data}{the name of data frame containing all the variables in the model and all the observations including those intended to be collected 
but became missing.}

\item{random}{an object of class "formula": an one-sided linear formula description of the random-effects part of the model to be fitted 
for the outcome}

\item{id}{the name of the level-2 clustering variable.}

\item{weights}{frequency weights to be assigned to each \code{id}. when supplied, indicates differential weights are used; otherwise each \code{id} is weighted equally.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process for the outcome model and the missingness mechanism model.}

\item{predprobobs}{Null if using buil-in multinomial transitional logistic model to obtain predicted probabilities of being observed;
otherwise user supply the name of the variable in \code{data} that gives these probabilities for all the observations in the data.}

\item{misni}{FALSE if using the default approach to computing ISNI with a scalar nonignorability parameter; 
TRUE when computing ISNI with multiple nonignorability parameters.}
}
\description{
Calculate the ISNI when the regression outcome is subject to missingness and follows linear mixed-effects models (LMMs)
}
\details{
The ISNI analysis is based on a joint selection model and requires specifying two model equations: the complete-data model and the missing data mechanism model.
       To specify the variables in the models that are required for computing the ISNI measures, we make use of the  \code{R} package "Formula"  designed for handling model
       equations with multiple responses    and multiple sets of predictors . At a minimum, the user should supply a single-equation 
        in the typical form:  \code{response} ~ \code{Xterms} where \code{response} is the (numeric or factor) vector for the outcome of interest and \code{Xterms} 
       is a series of terms, separated by + operators, which specify a linear predictor for response. With the signle-equation specification, the \code{isniglm} function 
       will by default use the utility function \code{definemissingstatus} provided in the package to generate the 
       missingness status variables at the current and prior visits and then use \code{Xterms} as the observed missingness predictors for fitting a first-order transitional missing data model. 
       It is important to sort within-\code{id} observations  by time so that the missingness status variables can be defined correctly in this default setting.  The \code{isnimgm} then computes the MAR estimates and conducts ISNI computation
       to evaluate the rate of change of model estimates in the neighborhood of the MAR model where the missingness probability is allowed to depend on the unobserved value 
       of \code{response},   even after  conditioning on the other  missingness predictors. 

       The above single-equation formula specification uses the same set of predictors for the outcome model and the missingness mechanism model for computing ISNI. 
       To use different sets of predictors, one can explicitly specifiy a two-equation formula as: \code{response} | \code{miss + missprior} ~ \code{Xterms} |  \code{Sterms},
       which specifies the formula  for the complete-data model as \code{response} ~ \code{Xterms} and that for the missing data mechanism model as \code{miss + missprior} ~ \code{Sterms}, 
       where \code{Xterms} and the observed predictors for missingness \code{Sterms} can be different, \code{miss} and \code{missprior} are the variable names in \code{data} denoting the missingness status at the 
       current and prior visits, respectively.  

       For \code{isnilmm}, \code{response} ~ \code{Xterms} specfied the fixed-effect part of the linear mixed-effects model for the outcome. The random-effect part of the model is
       specified as a one-sided formula via the argument \code{random}.
}
\examples{

data(qolef)
ymodel= y | g+ gp~   as.factor(time)*group+perf+sever

##Random intercept model
result=isnilmm(ymodel, random=~1, id=id,  data=qolef)
summary(result)

}
\references{
Hui Xie and Yi Qian (2012) Measuring the impact of nonignorability in panel data with non-monotone nonresponse., Journal of Applied Econometrics 27: 129-159. \cr
Hui Xie, Gao,W, Xing, B., Heitjan, D, Hedeker, D and Yuan, C. (2018) Measuring the Impact of Nonignorable Missingness Using the R packaeg isni, Computer Methods and Programs in Biomedicine 164 207-220.
}
