% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d13C.to.D13C.R
\name{d13C.to.D13C}
\alias{d13C.to.D13C}
\title{d13C.to.D13C}
\usage{
d13C.to.D13C(d13C, year, frac = 0)
}
\arguments{
\item{d13C}{Measured plant tissue carbon isotope signature, per mille (‰)}

\item{year}{Year to which the sample corresponds}

\item{frac}{Post-photosynthetic fractionation factor, defaults to 0 assuming leaf material, user should supply reasonable value if from wood (generally -1.9 - -2.1)}
}
\value{
Carbon isotope discrimination in units of per mille (‰)
}
\description{
Calculates leaf carbon isotope discrimination given plant tissue d13C signature.
}
\examples{
d13C.to.D13C(-27, 2015)




}
\references{
Badeck, F.-W., Tcherkez, G., Nogués, S., Piel, C. & Ghashghaie, J. (2005). Post-photosynthetic fractionation of stable carbon isotopes between plant organs—a widespread phenomenon. Rapid Commun. Mass Spectrom., 19, 1381–1391.

Belmecheri, S. & Lavergne, A. (2020). Compiled records of atmospheric CO2 concentrations and stable carbon isotopes to reconstruct climate and derive plant ecophysiological indices from tree rings. Dendrochronologia, 63, 125748.

Craig, H. (1953). The geochemistry of the stable carbon isotopes. Geochim. Cosmochim. Acta, 3, 53–92.

Farquhar, G., O’Leary, M. & Berry, J. (1982). On the relationship between carbon isotope discrimination and the intercellular carbon dioxide concentration in leaves. Aust. J. Plant Physiol., 9, 121–137.

Frank, D.C., Poulter, B., Saurer, M., Esper, J., Huntingford, C., Helle, G., et al. (2015). Water-use efficiency and transpiration across European forests during the Anthropocene. Nat. Clim. Chang., 5, 579–583.

Ubierna, N. & Farquhar, G.D. (2014). Advances in measurements and models of photosynthetic carbon isotope discrimination in C3 plants. Plant. Cell Environ., 37, 1494–1498.
}
