% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CumSumSuite.R
\name{makecumsumSurface}
\alias{makecumsumSurface}
\title{Create cumulative sum probability surface}
\usage{
makecumsumSurface(indivraster, rescale = FALSE, rename = FALSE)
}
\arguments{
\item{indivraster}{Normalized probability surface RasterLayer}

\item{rescale}{Rescale between 0 and 1? Defaults to FALSE.}

\item{rename}{Character value to append to raster name (e.g. "_odds"). Defaults to FALSE.}
}
\value{
Returns RasterLayer rescaled to Cumulative Sum values.
}
\description{
Converts normalized probability surface (e.g. one layer output of isotopeAssignmentModel function) to cumulative sum surfaces, i.e., one where the new value of a given cell is equal to the sum of all old values less than or equal to the old value of the cell.
}
\examples{
# Generate example probability surfaces.
myiso <- rasterFromXYZ(isoscape)
myiso_sd <- rasterFromXYZ(isoscape_sd)
df <- data.frame(
        ID = c(-100, -80, -50),
        isotopeValue = c(-100, -80, -50),
        SD_indv = rep(5, 3)
        )
assignmentModels <- isotopeAssignmentModel(
        ID = df$ID,
        isotopeValue = df$isotopeValue,
        SD_indv = df$SD_indv,
        precip_raster = myiso,
        precip_SD_raster = myiso_sd,
        nClusters = FALSE
        )

# Convert to cumulative sum surface.
cumulative_sum_surface <- stack(
     lapply( unstack( assignmentModels ), makecumsumSurface )
     )
plot(cumulative_sum_surface)

}
