% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{iso_find_absolute_path_roots}
\alias{iso_find_absolute_path_roots}
\title{Find roots for absolute paths}
\usage{
iso_find_absolute_path_roots(path, root = ".", check_existence = TRUE)
}
\arguments{
\item{path}{vector of file/folder paths, mixed relative and absolute paths are allowed.}

\item{root}{root directory for the isofiles. Can be relative to the current working directory (e.g. \code{"data"}) or an absolute path on the file system (e.g. \code{"/Users/..."} or \code{"C:/Data/.."}). The default is the current working directory (\code{"."}). Can be supplied as a vector of same length as the provided paths if the paths have different roots.}

\item{check_existence}{whether to check for the existence of the paths}
}
\value{
a data frame with the root directories and paths relative to the root - order of input paths is preserved
}
\description{
Helper function to find the roots of absolute paths. Tries to put absolute paths into the context of the relative root. For those that this is not possible (because they are not in fact a sub-path of the relative roots), identifies the greatest common denominator for absolute paths as their root. Does not change relative paths but does check whether they do exist if \code{check_existence = TRUE} (the default). To modify relative paths, use \link{iso_shorten_relative_paths} prior to calling this function.
}
\seealso{
Other file system functions: 
\code{\link{iso_expand_paths}()},
\code{\link{iso_root_paths}()},
\code{\link{iso_shorten_relative_paths}()}
}
\concept{file system functions}
