% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{iso_make_units_implicit}
\alias{iso_make_units_implicit}
\title{Make units implicit}
\usage{
iso_make_units_implicit(df, prefix = " [", suffix = "]")
}
\arguments{
\item{df}{the data frame in which to make the units implicit/explicit}

\item{prefix}{the prefix for the units}

\item{suffix}{the suffix for the units}
}
\description{
This function is intended for data frames /tibbles only and tries to figure out which numeric columns have units in the column names and makes those units implicit using \code{\link{iso_double_with_units}}. The reverse function is \code{\link{iso_make_units_explicit}}.
}
\examples{
# generate implicit units
df <- tibble(peak = 1:5, `height [V]` = 1:5)
iso_make_units_implicit(df)

# convert back and forth
iso_make_units_implicit(df) \%>\% iso_make_units_explicit()

# implicit units from custom prefix & suffix
df <- tibble(peak = 1:5, height.V = 1:5)
iso_make_units_implicit(df, prefix = ".", suffix = "")
}
\seealso{
Other functions for values with units: 
\code{\link{iso_get_units}()},
\code{\link{iso_is_double_with_units}()},
\code{\link{iso_make_units_explicit}()},
\code{\link{iso_strip_units}()},
\code{\link{iso_with_units}()}
}
\concept{functions for values with units}
