% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_methods-mcmc.list.R
\name{Ops.mcmc.list}
\alias{Ops.mcmc.list}
\title{Ops generics for \code{\link[coda]{mcmc.list}} objects}
\usage{
\method{Ops}{mcmc.list}(e1, e2)
}
\arguments{
\item{e1}{First operand}

\item{e2}{Second operand}
}
\value{
A \code{mcmc.list} object (with the added class
    \code{derived.mcmc.list}).
}
\description{
Ops generics for \code{\link[coda]{mcmc.list}} objects
}
\examples{
\dontrun{
# aquarium_run is a coda::mcmc.list object shipped with the isotracer package
a <- aquarium_run
plot(a)
# The calculations below are just given as examples of mathematical
# operations performed on an mcmc.list object, and do not make any sense
# from a modelling point of view.
plot(a[, "upsilon_algae_to_daphnia"] - a[, "lambda_algae"])
plot(a[, "upsilon_algae_to_daphnia"] + a[, "lambda_algae"])
plot(a[, "upsilon_algae_to_daphnia"] / a[, "lambda_algae"])
plot(a[, "upsilon_algae_to_daphnia"] * a[, "lambda_algae"])
plot(a[, "upsilon_algae_to_daphnia"] - 10)
plot(a[, "upsilon_algae_to_daphnia"] + 10)
plot(a[, "upsilon_algae_to_daphnia"] * 10)
plot(a[, "upsilon_algae_to_daphnia"] / 10)
plot(10 - a[, "upsilon_algae_to_daphnia"])
plot(10 + a[, "upsilon_algae_to_daphnia"])
plot(10 * a[, "upsilon_algae_to_daphnia"])
plot(10 / a[, "upsilon_algae_to_daphnia"])
}

}
