% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{write_unit}
\alias{write_unit}
\title{Write unit object into file}
\usage{
write_unit(unit, file)
}
\arguments{
\item{unit}{unit object. The unit object holds the data and theme of a single
dataset. This is the smallest data operation unit. At this level, individual
data can be fine-tuned. It is also possible to extract the style of a unit
for use in other units. It is also possible to use many units to learn a
complete itol.hub object. Almost all specific data operations behind the
itol.toolkit package are performed at the unit level. Because itol.hub
objects have comprehensive information, but to ensure that the correspondence
with phylogenetic branches or nodes remains consistent when different data
types are saved, many complex data aggregations are saved, which does not
facilitate data processing. Therefore, in the actual data processing process,
unit objects are generated from the itol.hub object and then processed.}

\item{file}{output file path. Define the output file location and file name
using absolute or relative path.}
}
\value{
No return value, only output a template file
}
\description{
Write itol.unit object into template file. This function will
using the type information in unit object to decide different output methods
for the template formats.
}
\examples{
tree <- system.file("extdata",
                    "tree_of_itol_templates.tree",
                    package = "itol.toolkit")
data("template_groups")
df_group <- data.frame(id = unique(template_groups$group),
                       data = unique(template_groups$group))
## create unit
unit <- create_unit(data = df_group,
                    key = "Quickstart",
                    type = "DATASET_COLORSTRIP",
                    tree = tree)
## write unit
write_unit(unit,tempfile())
}
