% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{plot_diff}
\alias{plotDiff}
\alias{plot_diff}
\title{Plot difference curve based on model predictions.}
\usage{
plot_diff(model, view, comp, cond = NULL, plotCI = TRUE, f = 1.96,
  eegAxis = FALSE, col = "black", shade = TRUE, n.grid = 100,
  add = FALSE, print.summary = getOption("itsadug_print"), plot = TRUE,
  rm.ranef = NULL, main = NULL, ylab = NULL, xlab = NULL, xlim = NULL,
  ylim = NULL, transform.view = NULL, mark.diff = TRUE,
  hide.label = FALSE, ...)
}
\arguments{
\item{model}{A GAMM model, resulting from the functions
\code{\link[mgcv]{gam}} or \code{\link[mgcv]{bam}}.}

\item{view}{Name of continuous predictor that should be plotted on the x-
axis.}

\item{comp}{Named list with the grouping predictor (categorical variable)
and the 2 levels to calculate the difference for.}

\item{cond}{A named list of the values to use for the predictor terms. 
Variables omitted from this list will have the closest observed value to 
the median for continuous variables, or the reference level for factors.}

\item{plotCI}{Logical: whether or not to plot confidence intervals. 
Default is TRUE.}

\item{f}{A number to scale the standard error. Defaults to 1.96, resulting 
in 95\% confidence intervals. For 99\% confidence intervals use a value of 
2.58.}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting 
negative values upwards. Default is FALSE.}

\item{col}{Line color. Shading color is derived from line color.}

\item{shade}{Logical: plot shaded confidence interval (TRUE) 
or dashed lines that indicate confidence region (FALSE).}

\item{n.grid}{Number of data points sampled as predictions. Defaults to 100.}

\item{add}{Logical: whether or not to add the line to an existing plot. 
Default is FALSE.
When no plot window is available and \code{add=TRUE}, 
the function will generate an error.}

\item{print.summary}{Logical: whether or not to print the summary. 
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{plot}{Logical: whether or not to plot the difference. If FALSE, then 
the output is returned as a list, with the estimated difference 
(\code{est}) and the standard error over the estimate (\code{se.est}) and 
the x-values (\code{x}). Default is TRUE.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is FALSE. Alternatively a string (or vector of strings) with the 
name of the random effect(s) to remove.}

\item{main}{Text string, alternative title for plot.}

\item{ylab}{Text string, alternative label for y-axis.}

\item{xlab}{Text string, alternative label for x-axis.}

\item{xlim}{Range of x-axis. If not specified, the function automatically 
generates an appropriate x-axis.}

\item{ylim}{Range of y-axis. If not specified, the function automatically 
generates an appropriate y-axis.}

\item{transform.view}{Function for transforming 
the values on the x-axis. Defaults to NULL (no transformation). 
(See \code{\link{plot_smooth}} for more info.)}

\item{mark.diff}{Logical: whether or not marking where the difference 
is significantly different from 0.}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., "difference"). Default is FALSE.}

\item{...}{Optional arguments for plot.}
}
\value{
If the result is not being plotted, a list is 
returned with the estimated difference (\code{est}) and the standard error 
over the estimate (\code{se}) and the x-values (\code{x}) is returned.
}
\description{
Plot difference curve based on model predictions.
}
\examples{
data(simdat)
\dontrun{
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group),
    data=simdat)
plot_diff(m1, view='Time', comp=list(Group=c("Children", "Adults")))
# Reversed y-axis (for EEG data):
plot_diff(m1, view='Time', comp=list(Group=c("Children", "Adults")), 
    eegAxis=TRUE)
# retrieving plot values...
out <- plot_diff(m1, view='Time', comp=list(Group=c("Children", "Adults")), 
   plot=FALSE)
#... which might be used for indicating differences:
x <- find_difference(out$est, out$se, f=1.96, xVals=out$xVals)
# add lines:
arrows(x0=x$start, x1=x$end, y0=0, y1=0,code=3, length=.1, col='red')
}

}
\author{
Martijn Wieling, Jacolien van Rij
}
\seealso{
Other Testing for significance: \code{\link{compareML}},
  \code{\link{plot_diff2}}, \code{\link{report_stats}},
  \code{\link{wald_gam}}
}

