% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect.R
\name{plot_data}
\alias{plot_data}
\title{Visualization of the model fit for time series data.}
\usage{
plot_data(model, view, split_by = NULL, cond = NULL, input = "data",
  rm.ranef = NULL, alpha = NULL, col = NULL, add = FALSE,
  eegAxis = FALSE, main = NULL, xlab = NULL, ylab = NULL, ylim = NULL,
  h0 = 0, v0 = NULL, hide.label = FALSE, transform = NULL,
  transform.view = NULL, print.summary = getOption("itsadug_print"), ...)
}
\arguments{
\item{model}{A lm or gam object, produced by \code{\link[mgcv]{gam}} or 
\code{\link[mgcv]{bam}}, \code{\link[stats]{lm}}, \code{\link[stats]{glm}}.}

\item{view}{Text string containing the predictor or column in the data 
to be displayed on the x-axis. 
Note that variables coerced to factors in the model formula 
won't work as view variables.}

\item{split_by}{Vector with names of model predictors that determine
the time series in the data, or should be used to split the ACF plot by.
Alternatively, \code{split_pred} can be a named list 
(each with equal length as the data) that 
group the data, fitted values or residuals 
values of \code{x} into trials or timeseries events. 
Generally other columns from the same data frame as the model was fitted on.}

\item{cond}{A named list of the values to use for the other predictor terms 
(not in view) or to select specific trials or time series to plot.}

\item{input}{Text string: "data" (default) plots the data, "resid" plots 
the model residuals, and "fitted" plots the fitted values.}

\item{rm.ranef}{Logical: whether or not to include the random effects in 
the model predictions. Default is TRUE. Relevant for \code{input="fitted"} 
and \code{input="resid"} (i.e., whether or not the residuals contain the 
random effects, TRUE and FALSE respectively ).}

\item{alpha}{Value between 0 and 1 indicating the transparency. 
A value of 0 is completely transparant, whereas a value of 1 is completely 
untransparant.}

\item{col}{Vector with one color value (i.e., all data points will have the 
same color), color values for each grouping condition specified in 
\code{split_by} or a vector with color values for each data point.}

\item{add}{Logical: whether or not to add the lines/points to an existing 
plot, or start a new plot (default).}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting the 
negative amplitudes upwards as traditionally is done in EEG research.
If eeg.axes is TRUE, labels for x- and y-axis are provided, when not 
provided by the user. Default value is FALSE.}

\item{main}{Changing the main title for the plot, see also title.}

\item{xlab}{Changing the label for the x axis, 
defaults to a description of x.}

\item{ylab}{Changing the label for the y axis, 
defaults to a description of y.}

\item{ylim}{the y limits of the plot.}

\item{h0}{A vector indicating where to add solid horizontal lines for 
reference. By default no values provided.}

\item{v0}{A vector indicating where to add dotted vertical lines for 
reference. By default no values provided.}

\item{hide.label}{Logical: whether or not to hide the label 
(i.e., "fitted values"). Default is FALSE.}

\item{transform}{Function for transforming the fitted values. 
Default is NULL.}

\item{transform.view}{Function for transforming the view values. 
Default is NULL.}

\item{print.summary}{Logical: whether or not to print a summary.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{...}{other options to pass on to lines and plot, 
see \code{\link[graphics]{par}}}
}
\description{
Plots the data, fitted values, or residuals.
}
\section{Notes}{

This function plots the fitted effects, including intercept and other 
predictors.
}
\examples{
data(simdat)

\dontrun{
# Create grouping predictor for time series:
simdat$Event <- interaction(simdat$Subject, simdat$Trial)

# model without random effects:
m1 <- bam(Y ~ te(Time, Trial) + s(Subject, bs='re'),
    data=simdat)

# All data points, without clustering:
plot_data(m1, view="Time")

# All data, clustered by Trial (very small dots):
plot_data(m1, view="Time", split_by="Trial",
    cex=.25)
# Add a smooth for each trial:
plot_smooth(m1, view="Time", plot_all="Trial", 
    add=TRUE, rm.ranef=TRUE)
# Add the model predictions in same color:
plot_smooth(m1, view="Time", plot_all="Trial", add=TRUE, rm.ranef=TRUE)

# Alternatively, use data to select events:
plot_data(m1, view="Time", split_by=list(Event=simdat$Event),
    type='l')
# which is the same as:
plot_data(m1, view="Time", split_by=list(Subject=simdat$Subject, Trial=simdat$Trial),
    type='l')
# Only for Trial=0
plot_data(m1, view="Time", split_by=list(Event=simdat$Event),
   cond=list(Trial=0), type='l')
# This is the same:
plot_data(m1, view="Time", split_by="Subject",
   cond=list(Trial=0), type='l')
# Add subject smooths:
plot_smooth(m1, view="Time", plot_all="Subject", 
    cond=list(Trial=0), add=TRUE)

# Change the colors:
plot_data(m1, view="Time", split_by="Subject",
   cond=list(Trial=0), type='l', col='gray', alpha=1)
}

}
\author{
Jacolien van Rij, idea of Tino Sering
}
\seealso{
Other Functions for model inspection: \code{\link{fvisgam}},
  \code{\link{gamtabs}}, \code{\link{inspect_random}},
  \code{\link{plot_parametric}}, \code{\link{plot_smooth}},
  \code{\link{plot_topo}}, \code{\link{pvisgam}}
}

