% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivregMethods.R
\name{vcov.ivreg}
\alias{vcov.ivreg}
\alias{ivregMethods}
\alias{bread.ivreg}
\alias{estfun.ivreg}
\alias{terms.ivreg}
\alias{model.matrix.ivreg}
\alias{predict.ivreg}
\alias{print.ivreg}
\alias{summary.ivreg}
\alias{print.summary.ivreg}
\alias{anova.ivreg}
\alias{update.ivreg}
\alias{residuals.ivreg}
\alias{Effect.ivreg}
\alias{formula.ivreg}
\alias{find_formula.ivreg}
\alias{alias.ivreg}
\alias{qr.ivreg}
\alias{vcovHC.ivreg}
\alias{model.matrix.ivreg_projected}
\alias{Anova.ivreg}
\alias{linearHypothesis.ivreg}
\title{Methods for \code{"ivreg"} Objects}
\usage{
\method{vcov}{ivreg}(object, ...)

bread.ivreg(x, ...)

estfun.ivreg(x, ...)

vcovHC.ivreg(x, ...)

\method{terms}{ivreg}(x, component = c("regressors", "instruments", "full"), ...)

\method{model.matrix}{ivreg}(
  object,
  component = c("regressors", "projected", "instruments"),
  ...
)

\method{model.matrix}{ivreg_projected}(object, ...)

\method{predict}{ivreg}(
  object,
  newdata,
  type = c("response", "terms"),
  na.action = na.pass,
  ...
)

\method{print}{ivreg}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{ivreg}(object, vcov. = NULL, df = NULL, diagnostics = TRUE, ...)

\method{print}{summary.ivreg}(
  x,
  digits = max(3, getOption("digits") - 3),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\method{anova}{ivreg}(object, object2, test = "F", vcov. = NULL, ...)

\method{update}{ivreg}(object, formula., ..., evaluate = TRUE)

\method{residuals}{ivreg}(
  object,
  type = c("response", "projected", "regressors", "working", "deviance", "pearson",
    "partial"),
  ...
)

Effect.ivreg(focal.predictors, mod, ...)

\method{formula}{ivreg}(x, component = c("complete", "regressors", "instruments"), ...)

find_formula.ivreg(x, ...)

\method{Anova}{ivreg}(mod, test.statistic = c("F", "Chisq"), ...)

\method{linearHypothesis}{ivreg}(
  model,
  hypothesis.matrix,
  rhs = NULL,
  test = c("F", "Chisq"),
  ...
)

\method{alias}{ivreg}(object, ...)

\method{qr}{ivreg}(x, ...)
}
\arguments{
\item{object, object2, model, mod}{An object of class \code{"ivreg"}.}

\item{...}{arguments to pass down.}

\item{x}{An object of class \code{"ivreg"} or \code{"summary.ivreg"}.}

\item{component}{For \code{\link{terms}}, \code{"regressors"}, \code{"instruments"}, or \code{"full"}; 
for \code{\link{model.matrix}}, \code{"projected"}, \code{"regressors"}, or \code{"instruments"};
for \code{\link{formula}}, \code{"regressors"}, \code{"instruments"},  or \code{"complete"}.}

\item{newdata}{Values of predictors for which to obtain predicted values.}

\item{type}{For \code{predict}, one of \code{"response"} (the default)  or \code{"terms"};
for \code{residuals}, one of \code{"response"} (the default), \code{"projected"}, \code{"regressors"},
\code{"working"}, \code{"deviance"}, \code{"pearson"}, or \code{"partial"}; 
\code{type = "working"} and \code{"response"} are equivalent, as are 
\code{type = "deviance"} and \code{"pearson"}.}

\item{na.action}{\code{na} method to apply to predictor values for predictions; default is \code{\link{na.pass}}.}

\item{digits}{For printing.}

\item{vcov.}{Optional coefficient covariance matrix, or a function to compute the covariance matrix, to use in computing the model summary.}

\item{df}{Optional residual degrees of freedom to use in computing model summary.}

\item{diagnostics}{Report 2SLS "diagnostic" tests in model summary (default is \code{TRUE}). 
These tests are not to be confused with the \emph{regression diagnostics} provided elsewhere in the \pkg{ivreg}
package: see \code{\link{ivregDiagnostics}}.}

\item{signif.stars}{Show "significance stars" in summary output.}

\item{test, test.statistic}{Test statistics for ANOVA table computed by \code{anova()}, \code{Anova()},
or \code{linearHypothesis()}. Only \code{test = "F"} is supported by \code{anova()}; this is also
the default for \code{Anova()} and \code{linearHypothesis()}, which also allow \code{test = "Chisq"} for
asymptotic tests.}

\item{formula.}{To update model.}

\item{evaluate}{If \code{TRUE}, the default, the updated model is evaluated; if \code{FALSE} the updated call is returned.}

\item{focal.predictors}{Focal predictors for effect plot, see \code{\link[effects:effect]{Effect}}.}

\item{hypothesis.matrix, rhs}{For formulating a linear hypothesis; see the documentation
for \code{\link{linearHypothesis}} for details.}
}
\description{
Various methods for processing \code{"ivreg"} objects; for diagnostic methods,
  see \code{\link{ivregDiagnostics}}.
}
\seealso{
\code{\link{ivreg}}, \code{\link{ivreg.fit}}, \code{\link{ivregDiagnostics}}
}
