context("ms simulation interface")

test_that("ms can be called", {
    expect_error(callMs())
    expect_true(file.exists(callMs("-t 5", dm.tt)))
})

test_that("msSimFunc is working", {
    set.seed(789)
    sum.stats <- msSingleSimFunc(dm.tt, c(1, 10))
    expect_true(is.list(sum.stats))
    expect_equal(length(sum.stats), 2)
    expect_false(is.null(sum.stats$pars))
    expect_equal(sum.stats$pars, c(1, 10))
    expect_false(is.null(sum.stats$jsfs))
    expect_true(is.array(sum.stats$jsfs))
    expect_equal(dim(sum.stats$jsfs), c(12, 13))
    expect_true(sum(sum.stats$jsfs) > 0)
    set.seed(789)
    sum.stats2 <- msSingleSimFunc(dm.tt, c(1, 10))
    expect_equal(sum.stats2, sum.stats)
    dm.tt@sum.stats <- data.frame()
    dm.tt <- dm.addSummaryStatistic(dm.tt, "seg.sites")
    set.seed(456)
    sum.stats <- msSingleSimFunc(dm.tt, c(1, 0.5))
    expect_equal(length(sum.stats), 2)
    expect_false(is.null(sum.stats$pars))
    expect_false(is.null(sum.stats$seg.sites))
    expect_true(is.list(sum.stats$seg.sites))
    expect_equal(length(sum.stats$seg.sites), dm.getLociNumber(dm.tt))
    for (seg.sites in sum.stats$seg.sites) {
        expect_true(is.matrix(seg.sites))
        expect_true(nrow(seg.sites) %in% c(0, 23))
    }
    set.seed(456)
    sum.stats2 <- msSingleSimFunc(dm.tt, c(1, 0.5))
    expect_equal(sum.stats2, sum.stats)
    dm.tt <- dm.addSummaryStatistic(dm.tt, "file")
    sum.stats <- msSingleSimFunc(dm.tt, c(1, 0.5))
    expect_equal(length(sum.stats), 3)
    expect_false(is.null(sum.stats$pars))
    expect_false(is.null(sum.stats$seg.sites))
    expect_false(is.null(sum.stats$file))
    expect_true(file.exists(sum.stats$file))
    expect_true((file.info(sum.stats$file)$size > 0))
    set.seed(123)
    dm.tt@sum.stats <- data.frame()
    dm.tt <- dm.addSummaryStatistic(dm.tt, "fpc")
    dm.tt <- calcFpcBreaks(dm.tt, sum.stats$seg.sites)
    set.seed(13579)
    sum.stats <- msSingleSimFunc(dm.tt, c(1, 10))
    expect_equal(length(sum.stats), 2)
    expect_false(is.null(sum.stats$pars))
    expect_true(is.array(sum.stats[["fpc"]]))
    expect_equal(sum(sum.stats[["fpc"]]), dm.getLociNumber(dm.tt))
    set.seed(13579)
    sum.stats2 <- msSingleSimFunc(dm.tt, c(1, 10))
    expect_equal(sum.stats2, sum.stats)
    dm.tt <- dm.addSummaryStatistic(dm.tt, "seg.sites")
    sum.stats <- msSingleSimFunc(dm.tt, c(1, 0.1))
    expect_equal(length(sum.stats), 3)
    expect_false(is.null(sum.stats$pars))
    expect_false(is.null(sum.stats$seg.sites))
    expect_true(is.array(sum.stats[["fpc"]]))
    expect_equal(sum(sum.stats[["fpc"]]), dm.getLociNumber(dm.tt))
})

test_that("the ms sim program exists", {
    expect_false(is.null(.jaatha$sim_progs[["ms"]]))
})
