% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flaggedSkewSchurPol.R
\name{flaggedSkewSchurPol}
\alias{flaggedSkewSchurPol}
\title{Flagged skew Schur polynomial}
\usage{
flaggedSkewSchurPol(lambda, mu, a, b)
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}

\item{a, b}{lower bounds and upper bounds, weakly increasing vectors of
integers; \code{lambda}, \code{a} and \code{b} must have the same length}
}
\value{
A \code{qspray} polynomial.
}
\description{
Computes a flagged skew Schur polynomial (which is not symmetric
  in general). See
  \href{https://www.symmetricfunctions.com/schurFlagged.htm#schurFlagged}{Schur polynomials (flagged)}
  for the definition.
}
\examples{
lambda <- c(3, 2, 2); mu <- c(2, 1)
n <- 3
a <- c(1, 1, 1); b <- c(n, n, n)
flaggedPoly <- flaggedSkewSchurPol(lambda, mu, a, b)
poly <- SkewSchurPol(n, lambda, mu)
flaggedPoly == poly # should be TRUE
}
