% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagshelper1.R
\name{comparecat}
\alias{comparecat}
\title{Compare Caterpillar Plots}
\usage{
comparecat(x, p = NULL, ci = c(0.5, 0.95), ylim = NULL, ...)
}
\arguments{
\item{x}{List of output objects returned from \code{jagsUI} or \code{data.frame}s}

\item{p}{Optional vector of parameters to subset.  All parameters with names matching the beginning of the
string supplied will be returned.  If the default (\code{NULL}) is accepted, all parameters will be plotted.}

\item{ci}{Credible intervals widths to plot.  Defaults to 50\% and 95\%.}

\item{ylim}{Y-axis limits for plotting}

\item{...}{additional plotting arguments}
}
\value{
\code{NULL}
}
\description{
Interleaved caterpillar plots for all parameters (or a specified subset) from a list of \code{jagsUI}
output objects or \code{data.frame}s.  The intent of this function is easy comparison of inferences from multiple comparable models.

Here a \link{caterpillar} plot is defined as a set of overlayed interval bars (default values are 50 percent and 95 percent),
with overlayed median markings, for each of a vector of parameter nodes.
}
\examples{
## This is the same output object three times, but shows functionality.
comparecat(x=list(asdf_jags_out, asdf_jags_out, asdf_jags_out),
           p=c("a","b","sig"))
}
\seealso{
\link{caterpillar}, \link{comparedens}
}
\author{
Matt Tyers
}
