% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{fillBlanks}
\alias{fillBlanks}
\title{Fill blank entries in a vector}
\usage{
fillBlanks(x, blankGrep = c("[ \\t]*"), first = "", ...)
}
\arguments{
\item{x}{character vector}

\item{blankGrep}{vector of grep patterns, or \code{NA}, indicating
the type of entry to be considered blank.
Each \code{blankGrep} pattern is searched using \code{jamba::proigrep()}, which
by default uses case-insensitive regular expression pattern
matching.}

\item{first}{options character string intended when the first
entry of \code{x} is blank. By default \code{""} is used.}

\item{...}{additional parameters are ignored.}
}
\value{
\code{character} vector where blank entries are filled with the
most recent non-blank value.
}
\description{
Fill blank entries in a vector
}
\details{
This function takes a character vector and fills any blank (missing)
entries with the last non-blank entry in the vector. It is intended
for situations like imported 'Excel' data, where there may be one
header value representing a series of cells.

The method used does not loop through the data, and should scale
fairly well with good efficiency even for extremely large vectors.
}
\examples{
x <- c("A", "", "", "", "B", "C", "", "", NA,
   "D", "", "", "E", "F", "G", "", "");
data.frame(x, fillBlanks(x));

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{padString}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
