% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\name{getBestSolutions}
\alias{getBestSolutions}
\title{Get best found solutions}
\usage{
getBestSolutions(data, problem, search)
}
\arguments{
\item{data}{data object containing the analysis results}

\item{problem}{name of the analyzed problem. Can be omitted if the
\code{data} contains results for a single problem only.}

\item{search}{name of the applied search. Can be omitted if the \code{data}
  contains results for a single search only (for the considered
  \code{problem}).}
}
\value{
List containing the best found solutions during each run. May contain
  \code{NA} values.
}
\description{
Get the best found solutions during the different runs of the given
\code{search} applied to the given \code{problem}. This is a generic S3
method.
}
\details{
If the \code{data} contains results for a single problem only, the argument
\code{problem} can be omitted. Likewise, if for the considered \code{problem}
results are available for a single search only, the argument \code{search}
can be omitted.

When writing results obtained from the analysis tools in the 'JAMES' extensions
module to a JSON file, one should provide a JSON converter for the solution
type of the analyzed problems if it is desired that the actual best found
solutions are contained in the output file. Therefore, these solutions might
not be available for all problems, searches or search runs. In case a best
solution is missing for a search run, the corresponding entry in the returned
list will be set to \code{NA}. It is possible that a list of only \code{NA}
is returned.
}

