% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_empties.R
\name{remove_empty}
\alias{remove_empty}
\title{Remove empty rows and/or columns from a data.frame or matrix.}
\usage{
remove_empty(dat, which = c("rows", "cols"))
}
\arguments{
\item{dat}{the input data.frame or matrix.}

\item{which}{one of "rows", "cols", or \code{c("rows", "cols")}.  Where no value of which is provided, defaults to removing both empty rows and empty columns, declaring the behavior with a printed message.}
}
\value{
Returns the object without its missing rows or columns.
}
\description{
Removes all rows and/or columns from a data.frame or matrix that are composed entirely of \code{NA} values.
}
\examples{
# not run:
# dat \%>\% remove_empty("rows")
}
\seealso{
\code{\link[=remove_constant]{remove_constant()}} for removing constant
columns.

Other remove functions: \code{\link{remove_constant}}
}
\concept{remove functions}
