% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hood.R
\name{hood}
\alias{hood}
\title{support functions for jenga}
\usage{
hood(ts, seq_len, k, method, kernel, ci, deriv, n_windows, mode, dates)
}
\arguments{
\item{ts}{A data frame with time features on columns}

\item{seq_len}{Positive integer. Time-step number of the projected sequence}

\item{k}{Positive integer. Number of neighbors to consider when applying kernel average. Min number is 3.}

\item{method}{Positive integer. Distance method for calculating neighbors. Possibile options are: "euclidean", "manhattan", "chebyshev", "sorensen", "gower", "soergel", "kulczynski_d", "canberra", "lorentzian", "intersection", "non-intersection", "wavehedges", "czekanowski", "motyka", "kulczynski_s", "tanimoto", "ruzicka", "inner_product", "harmonic_mean", "cosine", "hassebrook", "jaccard", "dice",  "fidelity",  "bhattacharyya", "squared_chord", "squared_euclidean", "pearson", "neyman", "squared_chi", "prob_symm", "divergence", "clark", "additive_symm", "taneja", "kumar-johnson", "avg".}

\item{kernel}{String. DIstribution used to calculate kernel densities. Possible options are: "norm", "cauchy", "logis", "unif", "t", "exp", "lnorm".}

\item{ci}{Confidence interval.}

\item{deriv}{Integer vector. Number of differentiation operations to perform for each original time feature. 0 = no change; 1: one diff; 2: two diff.}

\item{n_windows}{Positive integer. Number of validation tests to measure/sample error.}

\item{mode}{String. Sequencing method: deterministic ("segmented"), or non-deterministic ("sampled").}

\item{dates}{Date. Vector with dates for time features.}
}
\description{
support functions for jenga
}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
