% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_omv.R
\name{search_omv}
\alias{search_omv}
\title{Search values in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})}
\usage{
search_omv(
  dtaInp = NULL,
  srcTrm = c(),
  whlTrm = FALSE,
  ignCse = FALSE,
  incNum = TRUE,
  incOrd = TRUE,
  incNom = TRUE,
  incID = TRUE,
  incCmp = TRUE,
  incRcd = TRUE,
  ...
)
}
\arguments{
\item{dtaInp}{Either a data frame or the name of a jamovi data file to be read (including the path, if required; "FILENAME.omv"; default: NULL)}

\item{srcTrm}{(Character or numeric) Vector (with length = 1) with a search term to be found in the data frame (default: c())}

\item{whlTrm}{Whether the exact search term shall be found (TRUE) or whether a partial match is sufficient (FALSE; default: FALSE)}

\item{ignCse}{Whether to ignore the case of the search term (default: FALSE)}

\item{incNum}{Whether to include continuous variables in the search (default: TRUE)}

\item{incOrd}{Whether to include ordinal variables in the search (default: TRUE)}

\item{incNom}{Whether to include nominal variables in the search (default: TRUE)}

\item{incID}{Whether to include ID variables in the search (default: TRUE)}

\item{incCmp}{Whether to include Computed variables in the search (default: TRUE)}

\item{incRcd}{Whether to include Recoded variables in the search (default: TRUE)}

\item{...}{Additional arguments passed on to methods; see Details below}
}
\value{
a named list with the places where the search term was found: names in the list are the variables / columns, the entries the respective row names
within that variable / column (row names are used for being tolerant to filtered-out cases in jamovi, if a filter is used, row numbers would be
incorrect)
}
\description{
Search values in .omv-files for the statistical spreadsheet 'jamovi' (\url{https://www.jamovi.org})
}
\examples{
\dontrun{
library(jmvReadWrite)
# the exact value 24 appears 13 times in age
search_omv(bfi_sample, 24, whlTrm = TRUE)
# taking the fifth entry from the search results
bfi_sample["61", "age"]
# with the following search, both Males and Females are found
# (the M of Males, wouldn't be matched if ignCse were FALSE and males is
#  only a partial match within Females, thus whlTrm must be set to FALSE)
search_omv(bfi_sample, "males", whlTrm = FALSE, ignCse = TRUE)
# the first entry is a female, the first entry is a male
bfi_sample["1", "gender"] # Females
bfi_sample["6", "gender"] # Males
# using the search results assigned to a variable
srcRes <- search_omv(bfi_sample, "males", whlTrm = FALSE, ignCse = TRUE)
bfi_sample[srcRes[[1]][1], names(srcRes[1])] # Females
bfi_sample[srcRes[[1]][6], names(srcRes[1])] # Males
}

}
