% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vargm.R
\name{plot.vargm}
\alias{plot.vargm}
\title{Plots the empirical variogram for longitudinal data}
\usage{
\method{plot}{vargm}(x, smooth = FALSE, bdw = NULL, follow.time = NULL, points = TRUE, ...)
}
\arguments{
\item{x}{object of class \code{vargm} obtained by using function. 
\code{\link{variogram}}}

\item{smooth}{logical value to use a non-parametric estimator to calculate 
the variogram of all \eqn{v_ijk}. The default is \code{FALSE}, as it uses
time averages.}

\item{bdw}{bandwidth to use in the time averages. The default is \code{NULL},
because this is calculated automatically.}

\item{follow.time}{the interval of time we want to construct the variogram 
for. When \code{NULL} this is the maximum of the data.}

\item{points}{logical value if the points \eqn{v_ijk} should be plotted.}

\item{...}{other graphical options as in \code{\link[graphics]{par}}.}
}
\value{
A graphical device with the plot of empirical variogram.
}
\description{
Plots the empirical variogram for observed measurements, of an
  object of class \code{vargm}, obtained by using function
  \code{\link{variogram}}.
}
\examples{
data(mental)
mental.unbalanced <- to.unbalanced(mental, id.col = 1, 
                                   times = c(0, 1, 2, 4, 6, 8),
                                   Y.col = 2:7, 
                                   other.col = c(8, 10, 11))
names(mental.unbalanced)[3] <- "Y"
vgm <- variogram(indv = tail(mental.unbalanced[, 1], 30),
                 time = tail(mental.unbalanced[, 2], 30),
                 Y = tail(mental.unbalanced[, 3], 30))
plot(vgm)
}
\author{
Ines Sousa
}
\keyword{dplot}
