% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abbr_bib.R
\name{abbr_bib}
\alias{abbr_bib}
\alias{abbr_bib_only_journal}
\title{Journal field abbreviation of BibTeX file.}
\usage{
abbr_bib(
  file,
  out.file = tempfile(fileext = ".bib"),
  author.connect = c("nothing", "\\\\\\\\&", "&", "and"),
  user.csv = "",
  ...
)

abbr_bib_only_journal(
  file,
  out.file = tempfile(fileext = ".bib"),
  user.csv = "",
  ...
)
}
\arguments{
\item{file}{character, file path to write the \code{.bib} file.}

\item{out.file}{character, file path to write the \code{.bib} file.}

\item{author.connect}{character, what symbols are used to connect multiple authors, \code{'nothing','\\\\&',
'&', 'and'}, where \code{'nothing'} stand for do nothing(default).}

\item{user.csv}{character, csv file path, Users can customize the path of journal abbreviation.
The csv file requires semicolon to segment data without header.
The first column is the full name of the journal and the second column is the journal abbreviation.}

\item{...}{(generalized), Parameters from \code{data.table::fread}.}
}
\value{
{
  output a new Bib file and return a \code{data.table} object.
}
}
\description{
Input Bib file with complete journal, output a \code{.bib} file and return a data object.

Input Bib file with complete journal, output a \code{.bib} file, this function only carries out
  journal abbreviations, and the rest is output as it is.
}
\examples{
require(journalabbr)
path <- system.file("extdata", "testfile_2.bib", package = "journalabbr", mustWork = TRUE)
temptab <- abbr_bib(file = path, out.file = tempfile(fileext = ".bib"))

# add user csv
csvpath <- system.file("extdata", "myabbr.csv", package = "journalabbr", mustWork = TRUE)
temptab1 <- abbr_bib(file = path, out.file = tempfile(fileext = ".bib"), user.csv = csvpath)

# no return value
abbr_bib_only_journal(file = path, out.file = tempfile(fileext = ".bib"), user.csv = csvpath)

}
