% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{grid_class}
\alias{grid_class}
\alias{grid_80km}
\alias{grid_10km}
\alias{grid_1km}
\alias{grid_500m}
\alias{grid_250m}
\alias{grid_125m}
\alias{grid_100m}
\alias{grid_auto}
\alias{is_grid}
\title{Grid square code vector}
\usage{
grid_80km(x, strict = TRUE)

grid_10km(x, strict = TRUE)

grid_1km(x, strict = TRUE)

grid_500m(x, strict = TRUE)

grid_250m(x, strict = TRUE)

grid_125m(x, strict = TRUE)

grid_100m(x, strict = TRUE)

grid_auto(x, strict = TRUE)

is_grid(x)
}
\arguments{
\item{x}{A list or vector.}

\item{strict}{A logical scalar. Should the number of digits in the grid
square code match a given number of digits?}
}
\value{
A \code{grid} vector.
}
\description{
A series of functions return \code{grid} class for each grid size.
\code{grid_auto} returns automatically determine grid size by the largest
grid size.
}
\examples{
grid_80km("53394526313")
grid_80km("53394526313", strict = FALSE)

grid_auto(c("53394526313", "5339358633", "533945764"))
grid_auto(c("53394526313", "5339358633", "533945764"), strict = FALSE)
}
