% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{keys}
\alias{keys}
\alias{del}
\alias{del_}
\alias{haskey}
\alias{haskey_}
\title{Operations on keys, or by keys}
\usage{
keys(.data)

del(.data, ...)

del_(.data, ..., .dots)

haskey(.data, ...)

haskey_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
\code{keys} takes no input, and retrieves keys. \code{del} deletes
provided keys. \code{haskey} checks if a json string has a key, or the
input array has an element at the given index.
}
\examples{
# get keys
str <- '{"foo": 5, "bar": 7}'
jq(str, "keys")
str \%>\% keys()

# delete by key name
jq(str, "del(.bar)")
str \%>\% del(bar)

# check for key existence
str3 <- '[[0,1], ["a","b","c"]]'
jq(str3, "map(has(2))")
str3 \%>\% haskey(2)
jq(str3, "map(has(1,2))")
str3 \%>\% haskey(1,2)

## many JSON inputs
'{"foo": 5, "bar": 7} {"hello": 5, "world": 7}' \%>\% keys
'{"foo": 5, "bar": 7} {"hello": 5, "bar": 7}' \%>\% del(bar)
}
