% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{CalculateUMAPSickleJr}
\alias{CalculateUMAPSickleJr}
\title{Calculate the UMAP for an object of class SickleJr}
\usage{
CalculateUMAPSickleJr(
  SickleJr,
  umap.settings = umap::umap.defaults,
  modality = NULL
)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{umap.settings}{Optional settings for the \code{\link[umap]{umap}}; defaults to \code{\link[umap]{umap.defaults}}}

\item{modality}{A number corresponding to the desired modality; if set, will perform UMAP on
\eqn{\mathbf{W}^{\mathtt{modality}}}%*%t(\eqn{\mathbf{H}}) rather than
on \eqn{\mathbf{H}} alone; not recommended for datasets of more than 1000 cells}
}
\value{
An object of class SickleJr with UMAP output based on the \eqn{\mathbf{H}} matrix alone or within a modality added to its \code{umap} slot
}
\description{
Perform UMAP on the \eqn{\mathbf{H}} matrix alone (default) or within a modality by
using UMAP on the \eqn{W^vH} corresponding to modality \eqn{v}.
}
\examples{
#Since this example has only 10 observations,
#we need to modify the number of neighbors from the default of 15
umap.settings=umap::umap.defaults
umap.settings$n_neighbors=2
SimSickleJrSmall<-CalculateUMAPSickleJr(SimSickleJrSmall,
umap.settings=umap.settings)
SimSickleJrSmall<-CalculateUMAPSickleJr(SimSickleJrSmall,
umap.settings=umap.settings,modality=1)
SimSickleJrSmall<-CalculateUMAPSickleJr(SimSickleJrSmall,
umap.settings=umap.settings,modality=2)
}
\references{
\insertRef{UMAP}{jrSiCKLSNMF}
}
