% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{limitStorage}
\alias{limitStorage}
\title{Change size of the message storage}
\usage{
limitStorage(n = NULL, size = NULL)
}
\arguments{
\item{n}{Number of messages that can be stored simultaneously.}

\item{size}{Maxim total size of all stored messages in bytes.}
}
\value{
Current maximum size of the storage and maximum allowed number of stored messages.
}
\description{
This function allows to change number of total size of the messages
that are received via the websocket and are stored in the memory.
}
\details{
For security reasons, the control of the currently running R session is limited
to calling only some user specified functions and reassigning some user specified
variables. All other messages are stored in the memory and can be later processed
by calling \code{\link{authorize}} function. To prevent overuse of memory, one can 
limit the size of the storage by number of messages or by their total size estimated
by \code{\link[utils]{object.size}}. If the storage grows above the set limits, older
messages are removed. The last received message will not be removed even if its 
takes more memory than is allowed by this function.
}
\examples{
limitStorage(n = 10)
limitStorage(size = 10 * 1024^2)
lim <- limitStorage()

}
\seealso{
\code{\link{authorize}}, \code{\link{allowFunctions}}, \code{\link{allowVariables}}.
}
