% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs.R
\name{ggpairsModule2}
\alias{ggpairsModule2}
\title{ggpairsModule2: shiny module server for basic/scatter plot for reactive data.}
\usage{
ggpairsModule2(
  input,
  output,
  session,
  data,
  data_label,
  data_varStruct = NULL,
  nfactor.limit = 20
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{data_varStruct}{List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit for categorical variables, Default: 20}
}
\value{
Shiny module server for basic/scatter plot
}
\description{
Shiny module server for basic/scatter plot for reactive data.
}
\details{
Shiny module server for basic/scatter plot for reactive data.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
library(ggplot2)
library(GGally)

ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      ggpairsModuleUI1("ggpairs")
    ),
    mainPanel(
      plotOutput("ggpairs_plot"),
      ggpairsModuleUI2("ggpairs")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_ggpairs <- callModule(ggpairsModule2, "ggpairs",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$kaplan_plot <- renderPlot({
    print(out_ggpairs())
  })
}
}
