% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ.R
\name{summ.merMod}
\alias{summ.merMod}
\alias{j_summ.merMod}
\title{Mixed effects regression summaries with options}
\usage{
\method{summ}{merMod}(model, scale = FALSE,
  confint = getOption("summ-confint", FALSE),
  ci.width = getOption("summ-ci.width", 0.95),
  conf.method = getOption("summ-conf.method", c("Wald", "profile",
  "boot")), digits = getOption("jtools-digits", default = 2),
  r.squared = TRUE, pvals = getOption("summ-pvals", NULL), n.sd = 1,
  center = FALSE, transform.response = FALSE, data = NULL,
  exp = FALSE, t.df = NULL, model.info = getOption("summ-model.info",
  TRUE), model.fit = getOption("summ-model.fit", TRUE),
  re.variance = getOption("summ-re.variance", c("sd", "var")),
  which.cols = NULL, re.table = getOption("summ-re.table", TRUE),
  groups.table = getOption("summ-groups.table", TRUE), ...)
}
\arguments{
\item{model}{A \code{\link[lme4]{merMod}} object.}

\item{scale}{If \code{TRUE}, reports standardized regression
coefficients. Default is \code{FALSE}.}

\item{confint}{Show confidence intervals instead of standard errors? Default
is \code{FALSE}.}

\item{ci.width}{A number between 0 and 1 that signifies the width of the
desired confidence interval. Default is \code{.95}, which corresponds
to a 95\% confidence interval. Ignored if \code{confint = FALSE}.}

\item{conf.method}{Argument passed to \code{\link[lme4:confint.merMod]{lme4::confint.merMod()}}. Default
is \code{"Wald"}, but \code{"profile"} or \code{"boot"} are better when accuracy is a
priority. Be aware that both of the alternate methods are sometimes very
time-consuming.}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 2. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired
number.}

\item{r.squared}{Calculate an r-squared model fit statistic? Default is
\code{TRUE}, but if it has errors or takes a long time to calculate you
may want to consider setting to FALSE.}

\item{pvals}{Show p values? If \code{FALSE}, these
are not printed. Default is \code{TRUE}, except for merMod objects (see
details).}

\item{n.sd}{If \code{scale = TRUE}, how many standard deviations should
predictors be divided by? Default is 1, though some suggest 2.}

\item{center}{If you want coefficients for mean-centered variables but don't
want to standardize, set this to \code{TRUE}.}

\item{transform.response}{Should scaling/centering apply to response
variable? Default is \code{FALSE}.}

\item{data}{If you provide the data used to fit the model here, that data
frame is used to re-fit the model (if \code{scale} is \code{TRUE})
instead of the \code{\link[stats:model.frame]{stats::model.frame()}}
of the model. This is particularly useful if you have variable
transformations or polynomial terms specified in the formula.}

\item{exp}{If \code{TRUE}, reports exponentiated coefficients with
confidence intervals for exponential models like logit and Poisson models.
This quantity is known as an odds ratio for binary outcomes and incidence
rate ratio for count models.}

\item{t.df}{For \code{lmerMod} models only. User may set the degrees of
freedom used in conducting t-tests. See details for options.}

\item{model.info}{Toggles printing of basic information on sample size,
name of DV, and number of predictors.}

\item{model.fit}{Toggles printing of model fit statistics.}

\item{re.variance}{Should random effects variances be expressed in
standard deviations or variances? Default, to be consistent with previous
versions of \code{jtools}, is \code{"sd"}. Use \code{"var"} to get the variance instead.}

\item{which.cols}{Developmental feature. By providing columns by name,
you can add/remove/reorder requested columns in the output. Not fully
supported, for now.}

\item{re.table}{Show table summarizing variance of random effects? Default
is TRUE.}

\item{groups.table}{Show table summarizing the grouping variables? Default
is TRUE.}

\item{...}{Among other things, arguments are passed to \code{\link[=scale_mod]{scale_mod()}} or
\code{\link[=center_mod]{center_mod()}} when \code{center} or \code{scale} is \code{TRUE}.}
}
\value{
If saved, users can access most of the items that are returned in
the output (and without rounding).

\item{coeftable}{The outputted table of variables and coefficients}
\item{rcoeftable}{The secondary table with the grouping variables and
random coefficients.}
\item{gvars}{The tertiary table with the grouping variables, numbers of
groups, and ICCs.}
\item{model}{The model for which statistics are displayed. This would be
most useful in cases in which \code{scale = TRUE}.}

Much other information can be accessed as attributes.
}
\description{
\code{summ()} prints output for a regression model in a fashion similar to
\code{summary()}, but formatted differently with more options.
}
\details{
By default, this function will print the following items to the
console:
\itemize{
\item The sample size
\item The name of the outcome variable
\item The (Pseudo-)R-squared value and AIC/BIC.
\item A table with regression coefficients, standard errors, and t-values.
}

The \code{scale} and \code{center} options are performed via refitting
the model with \code{\link[=scale_mod]{scale_mod()}} and \code{\link[=center_mod]{center_mod()}},
respectively. Each of those in turn uses \code{\link[=gscale]{gscale()}} for the
mean-centering and scaling.

\code{merMod} models are a bit different than the others. The \code{lme4}
package developers have, for instance, made a decision not to report or
compute p values for \code{lmer()} models. There are good reasons for this,
most notably that the t-values produced are not "accurate" in the sense of
the Type I error rate. For certain large, balanced samples with many
groups, this is no big deal. What's
a "big" or "small" sample? How much balance is necessary? What type of
random effects structure is okay? Good luck getting a statistician to
give you any clear guidelines on this.
Some simulation studies have been done on fewer than 100 observations, so
for sure if your sample is around 100 or fewer you should not interpret
the t-values. A large number of groups is also crucial for avoiding bias
using t-values. If groups are nested or crossed in a linear model,
it is best to just get the \pkg{pbkrtest} package.

By default, this function follows \code{lme4}'s lead and does not report
the p values for \code{lmer()} models. If the user has \pkg{pbkrtest}
installed, however, p values are reported using the Kenward-Roger
d.f. approximation unless \code{pvals = FALSE} or \code{t.df} is
set to something other than \code{NULL}. In publications,
you should cite the
Kenward & Roger (1997) piece as well as either this package or
\pkg{pbkrtest} package to explain how the p values were calculated.

See \code{\link[lme4]{pvalues}} from the \pkg{lme4} for more details.
If you're looking for a simple test with no extra packages installed,
it is better to use the confidence
intervals and check to see if they exclude zero than use the t-test.
For users of \code{glmer()}, see some of the advice there as well. While
\code{lme4} and by association \code{summ()} does as well, they are
still imperfect.

You have some options to customize the output in this regard with the
\code{t.df} argument. If \code{NULL}, the default, the
degrees of freedom used depends on whether the user has
\pkg{lmerTest} or \pkg{pbkrtest} installed. If \code{lmerTest} is installed,
the degrees of freedom for each coefficient are calculated using the
Satterthwaite method and the p values calculated accordingly.
If only \code{pbkrtest} is installed or \code{t.df} is \code{"k-r"}, the Kenward-Roger
approximation of the standard errors and degrees of freedom for each
coefficient is used. Note that Kenward-Roger standard errors can take
longer to calculate and may cause R to crash with models fit to large
(roughly greater than 5000 rows) datasets.

If neither is installed and the user sets
\code{pvals = TRUE}, then the residual degrees of freedom
is used. If \code{t.df = "residual"}, then the residual d.f. is used
without a message. If the user prefers to use some other method to
determine the d.f., then any number provided as the argument will be
used.

\strong{About pseudo-R^2}

There is no one way to calculate R^2 for mixed models or nonlinear
models. Many caution against interpreting or even using such
approximations outside of OLS regression. With that said, this package
reports one version for your benefit, though you should of course
understand that it is not an unambiguous measure of model fit.

This package calculates R^2 for mixed models using an adapted version
of \code{sem.model.fits()} from the \pkg{piecewiseSEM}
package. This is an implementation of the Nakagawa & Schielzeth (2013)
procedure with refinements by Johnson (2014). If you choose to report
the pseudo-R^2 in a publication, you should cite Nakagawa & Schielzeth
to explain how the calculation was done.
}
\examples{
if (requireNamespace("lme4")) {
  library(lme4, quietly = TRUE)
  data(sleepstudy)
  mv <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

  summ(mv) # Note lack of p values if you don't have lmerTest/pbkrtest

  # Without lmerTest/pbkrtest, you'll get message about Type 1 errors
  summ(mv, pvals = TRUE)

  # To suppress message, manually specify t.df argument
  summ(mv, t.df = "residual")

  # Confidence intervals may be better alternative to p values
  summ(mv, confint = TRUE)
  # Use conf.method to get profile intervals (may be slow to run)
  # summ(mv, confint = TRUE, conf.method = "profile")

}

}
\references{
Johnson, P. C. D. (2014). Extension of Nakagawa & Schielzeth's
$R^{2}_{GLMM}$ to random slopes models. \emph{Methods in Ecology and
Evolution}, \emph{5}, 944–946. \url{https://doi.org/10.1111/2041-210X.12225}

Kenward, M. G., & Roger, J. H. (1997). Small sample inference for fixed
effects from restricted maximum likelihood. \emph{Biometrics},
\emph{53}, 983.
\url{https://doi.org/10.2307/2533558}

Kuznetsova, A., Brockhoff, P. B., & Christensen, R. H. B. (2017). lmerTest
package: Tests in linear mixed effects models.
\emph{Journal of Statistical Software}, \emph{82}.
\url{https://doi.org/10.18637/jss.v082.i13}

Luke, S. G. (2017). Evaluating significance in linear mixed-effects models
in R. \emph{Behavior Research Methods}, \emph{49}, 1494–1502.
\url{https://doi.org/10.3758/s13428-016-0809-y}

Nakagawa, S., & Schielzeth, H. (2013). A general and simple method for
obtaining $R^2$ from generalized linear mixed-effects models.
\emph{Methods in Ecology and Evolution}, \emph{4}, 133–142.
\url{https://doi.org/10.1111/j.2041-210x.2012.00261.x}
}
\seealso{
\code{\link[=scale_mod]{scale_mod()}} can simply perform the standardization if
preferred.

\code{\link[=gscale]{gscale()}} does the heavy lifting for mean-centering and scaling
behind the scenes.

\code{\link[pbkrtest:get_ddf_Lb]{pbkrtest::get_ddf_Lb()}} gets the Kenward-Roger degrees of
freedom if you have \pkg{pbkrtest} installed.

A tweaked version of \code{\link[piecewiseSEM:sem.model.fits]{piecewiseSEM::sem.model.fits()}} is used to
generate the pseudo-R-squared estimates for linear models.

Other summ: \code{\link{summ.glm}}, \code{\link{summ.lm}},
  \code{\link{summ.rq}}, \code{\link{summ.svyglm}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
\concept{summ}
