% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odds_ratio.R
\name{odds_ratio}
\alias{odds_ratio}
\alias{a_odds_ratio_j}
\alias{s_odds_ratio_j}
\title{Odds ratio estimation}
\usage{
a_odds_ratio_j(
  df,
  .var,
  .df_row,
  ref_path,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_odds_ratio_j(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  .df_row,
  variables = list(arm = NULL, strata = NULL),
  conf_level = 0.95,
  groups_list = NULL,
  na_if_no_events = TRUE,
  method = c("exact", "approximate", "efron", "breslow", "cmh")
)
}
\arguments{
\item{df}{(\code{data.frame})\cr input data frame.}

\item{.var}{(\code{string})\cr name of the response variable.}

\item{.df_row}{(\code{data.frame})\cr data frame containing all rows.}

\item{ref_path}{(\code{character})\cr path to the reference group.}

\item{.spl_context}{(\code{environment})\cr split context environment.}

\item{...}{Additional arguments passed to the statistics function.}

\item{.stats}{(\code{character})\cr statistics to calculate.}

\item{.formats}{(\code{list})\cr formats for the statistics.}

\item{.labels}{(\code{list})\cr labels for the statistics.}

\item{.indent_mods}{(\code{list})\cr indentation modifications for the statistics.}

\item{.ref_group}{(\code{data.frame})\cr reference group data frame.}

\item{.in_ref_col}{(\code{logical})\cr whether the current column is the reference column.}

\item{variables}{(\code{list})\cr list with arm and strata variable names.}

\item{conf_level}{(\code{numeric})\cr confidence level for the confidence interval.}

\item{groups_list}{(\code{list})\cr list of groups for combination.}

\item{na_if_no_events}{(\code{flag})\cr whether the point estimate should be \code{NA} if there
are no events in one arm. The p-value and confidence interval will still be computed.}

\item{method}{(\code{string})\cr whether to use the correct (\code{'exact'}) calculation in the conditional likelihood or one
of the approximations, or the CMH method. See \code{\link[survival:clogit]{survival::clogit()}} for details.}
}
\value{
\itemize{
\item \code{a_odds_ratio_j()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{s_odds_ratio_j()} returns a named list with the statistics \code{or_ci}
(containing \code{est}, \code{lcl}, and \code{ucl}), \code{pval} and \code{n_tot}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\section{Functions}{
\itemize{
\item \code{a_odds_ratio_j()}: Formatted analysis function which is used as \code{afun}. Note that the
junco specific \code{ref_path} and \code{.spl_context} arguments are used for reference column information.

\item \code{s_odds_ratio_j()}: Statistics function which estimates the odds ratio
between a treatment and a control. A \code{variables} list with \code{arm} and \code{strata}
variable names must be passed if a stratified analysis is required.

}}
\note{
The \code{a_odds_ratio_j()} and \code{s_odds_ratio_j()} functions have the \verb{_j} suffix to distinguish them
from \code{\link[tern:odds_ratio]{tern::a_odds_ratio()}} and \code{\link[tern:odds_ratio]{tern::s_odds_ratio()}}, respectively.
These functions differ as follows:
\itemize{
\item Additional \code{method = 'cmh'} option is provided to calculate the Cochran-Mantel-Haenszel estimate.
\item The p-value is returned as an additional statistic.
}

Once these updates are contributed back to \code{tern}, they can later be replaced by the \code{tern} versions.
}
\examples{
set.seed(12)
dta <- data.frame(
  rsp = sample(c(TRUE, FALSE), 100, TRUE),
  grp = factor(rep(c("A", "B"), each = 50), levels = c("A", "B")),
  strata = factor(sample(c("C", "D"), 100, TRUE))
)

a_odds_ratio_j(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  ref_path = c("grp", "B"),
  .spl_context = data.frame(
    cur_col_split = I(list("grp")),
    cur_col_split_val = I(list(c(grp = "A"))),
    full_parent_df = I(list(dta))
  ),
  .df_row = dta
)


l <- basic_table() |>
  split_cols_by(var = "grp") |>
  analyze(
    "rsp",
    afun = a_odds_ratio_j,
    show_labels = "hidden",
    extra_args = list(
      ref_path = c("grp", "B"),
      .stats = c("or_ci", "pval")
    )
  )

build_table(l, df = dta)

l2 <- basic_table() |>
  split_cols_by(var = "grp") |>
  analyze(
    "rsp",
    afun = a_odds_ratio_j,
    show_labels = "hidden",
    extra_args = list(
      variables = list(arm = "grp", strata = "strata"),
      method = "cmh",
      ref_path = c("grp", "A"),
      .stats = c("or_ci", "pval")
    )
  )

build_table(l2, df = dta)
s_odds_ratio_j(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  .df_row = dta
)

s_odds_ratio_j(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  .df_row = dta,
  variables = list(arm = "grp", strata = "strata")
)

s_odds_ratio_j(
  df = subset(dta, grp == "A"),
  method = "cmh",
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  .df_row = dta,
  variables = list(arm = "grp", strata = c("strata"))
)
}
