# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Set attribute on any SEXP in place
#'
#' @examples
#' \dontrun{
#' # benchmark to see whether setting an attribute on a function argument and returning it does a copy.
#' f <- function(x) { attr(x, "a") <- FALSE; x }
#' p <- generate_random_short_icd9(1)
#' q <- generate_random_short_icd9(1e6)
#' times <- 1e5
#' microbenchmark::microbenchmark(f(p), set_attr_in_place(p, "a", FALSE),
#'                                f(q), set_attr_in_place(q, "a", FALSE), times = times)
#' p2 <- p3 <- generate_random_short_icd9(1)
#' set_attr_in_place(p2, "a", FALSE)
#' stopifnot(identical(f(p3), p2))
#' # oh dear, \code{f} does copy.
#'
#' # see if we can return without deep copy using Rcpp:
#'
#' p4 <- p
#' q4 <- q
#' setDecimalCodeInPlace(p4)
#' stopifnot(identical(p4, setDecimalCode(p4)))
#' microbenchmark::microbenchmark(setDecimalCodeInPlace(p), setDecimalCode(p), times = times)
#' microbenchmark::microbenchmark(setDecimalCodeInPlace(q), setDecimalCode(q), times = times)
#'
#'
#' }
#' @param x Any R object for which an attribute can be set
#' @param name The name of the attribute, as length one character vector
#' @param value Value to be assigned to that attribute
#' @export
set_attr_in_place <- function(x, name, value) {
    invisible(.Call(`_jwutil_set_attr_in_place`, x, name, value))
}

getOmpMaxThreads <- function() {
    .Call(`_jwutil_getOmpMaxThreads`)
}

getOmpThreads <- function() {
    .Call(`_jwutil_getOmpThreads`)
}

isRowSorted <- function(x) {
    .Call(`_jwutil_isRowSorted`, x)
}

#' @name propRowSorted
#' @title proportion of non-descending rows in matrix
#' @description first performs isRowSorted to get a logical vector,
#' then sums TRUE values and takes fraction of total
#' @param x matrix, each row containing ordered or disordered numerics
#' @return double, the proportion from 0 to 1
#' @export
propRowSorted <- function(x) {
    .Call(`_jwutil_propRowSorted`, x)
}

#' @name fastIntToString
#' @title Fast convert integer vector to character vector
#' @description Fast conversion from integer vector to character vector using C++
#' @param x vector of integers
#' @param bufferSize int if any input strings are longer than this number
#'   (default 16) there will be memory errors. No checks done for speed.
#' @examples
#' \dontrun{
#' pts <- generate_random_pts(1e7)
#' # conclusion: buffer size matters little (so default to be more generous),
#' # and Rcpp version fastest.
#' microbenchmark::microbenchmark(fastIntToStringStd(pts$visit_id, buffer = 8),
#'                                fastIntToStringStd(pts$visit_id, buffer = 16),
#'                                fastIntToStringStd(pts$visit_id, buffer = 64),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 8),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 16),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 64),
#'                                as.character(pts$visit_id),
#'                                as_char_no_warn(pts$visit_id), times = 5)
#' }
#' @keywords internal
fastIntToStringStd <- function(x) {
    .Call(`_jwutil_fastIntToStringStd`, x)
}

#' @describeIn fastIntToString Same using Rcpp
#' @export
fastIntToStringRcpp <- function(x) {
    .Call(`_jwutil_fastIntToStringRcpp`, x)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_jwutil_RcppExport_registerCCallable', PACKAGE = 'jwutil')
})
